/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.data;

import java.util.Map;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.PersistentElement;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.utils.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Resource
extends PersistentElement
implements Iterable<Entry> {
    public abstract Element get(Term var1) throws InvalidTermException;

    public abstract Element put(Term var1, Element var2) throws InvalidTermException;

    public abstract int size();

    @Override
    public Element rget(Term[] terms, int index, boolean protect, boolean lookupOnly) throws InvalidTermException {
        Element rvalue = this;
        int remaining = terms.length - index - 1;
        if (remaining >= 0) {
            try {
                rvalue = this.get(terms[index]);
            }
            catch (InvalidTermException ite) {
                throw ite.setInfo(terms, index, this.getTypeAsString());
            }
            if (rvalue != null && remaining > 0) {
                boolean pflag = protect || rvalue.isProtected();
                rvalue = rvalue.rget(terms, index + 1, pflag, lookupOnly);
            }
        }
        return rvalue;
    }

    @Override
    public void rput(Term[] terms, int index, Element value) throws InvalidTermException {
        int remaining = terms.length - index - 1;
        if (remaining < 0) {
            throw CompilerError.create("MSG_INVALID_PATH_INDEX", index, terms.length);
        }
        Term term = terms[index];
        if (remaining == 0) {
            try {
                this.put(term, value);
            }
            catch (InvalidTermException ite) {
                throw ite.setInfo(terms, index, this.getTypeAsString());
            }
        }
        if (remaining > 0) {
            Element child = null;
            try {
                child = this.get(term);
            }
            catch (InvalidTermException ite) {
                throw ite.setInfo(terms, index, this.getTypeAsString());
            }
            if (child != null && child.isProtected()) {
                child = child.writableCopy();
                this.put(term, child);
            }
            if (child == null || child instanceof Undef) {
                child = terms[index + 1].isKey() ? new HashResource() : new ListResource();
                this.put(term, child);
            }
            if (child.isProtected()) {
                Element replacement = child.writableCopy();
                this.put(term, replacement);
                child = replacement;
            }
            child.rput(terms, index + 1, value);
        }
    }

    @Override
    public ListResource rgetList(Term[] terms, int index) throws InvalidTermException {
        ListResource result = null;
        int remaining = terms.length - index - 1;
        if (remaining < 0) {
            throw CompilerError.create("MSG_INVALID_PATH_INDEX", index, terms.length);
        }
        Term term = terms[index];
        if (remaining == 0) {
            try {
                Element element = this.get(term);
                if (element instanceof ListResource) {
                    result = (ListResource)element;
                }
                if (element instanceof Undef || element == null) {
                    result = new ListResource();
                    this.put(term, result);
                }
                throw EvaluationException.create("MSG_REFERENCED_VARIABLE_NOT_LIST", element.getTypeAsString());
            }
            catch (InvalidTermException ite) {
                throw ite.setInfo(terms, index, this.getTypeAsString());
            }
        } else if (remaining > 0) {
            Element child = null;
            try {
                child = this.get(term);
            }
            catch (InvalidTermException ite) {
                throw ite.setInfo(terms, index, this.getTypeAsString());
            }
            if (child == null || child instanceof Undef) {
                child = terms[index + 1].isKey() ? new HashResource() : new ListResource();
                this.put(term, child);
            }
            assert (child != null);
            if (child.isProtected()) {
                child = child.writableCopy();
                this.put(term, child);
            }
            result = child.rgetList(terms, index + 1);
        }
        return result;
    }

    public abstract Iterator iterator();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Iterator
    extends java.util.Iterator<Entry> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Entry
    extends Map.Entry<Property, Element> {
    }
}

