/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Digest
extends BuiltInFunction {
    private Digest(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("digest", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 2) {
            throw SyntaxException.create(sourceRange, "MSG_TWO_ARGS_REQ", "digest");
        }
        if (operations[0] instanceof Element) {
            if (operations[0] instanceof StringProperty) {
                String algorithm = ((StringProperty)operations[0]).getValue();
                try {
                    MessageDigest.getInstance(algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    throw SyntaxException.create(sourceRange, "MSG_INVALID_DIGEST_ALGORITHM", algorithm);
                }
            } else {
                throw SyntaxException.create(sourceRange, "MSG_FIRST_STRING_ARG_REQ", "digest");
            }
        }
        if (operations[1] instanceof Element && !(operations[1] instanceof StringProperty)) {
            throw EvaluationException.create(sourceRange, "MSG_SECOND_STRING_ARG_REQ", "digest");
        }
        return new Digest(sourceRange, operations);
    }

    public Element execute(Context context) {
        Element[] args = this.calculateArgs(context);
        assert (args.length == 2);
        String algorithm = "";
        String message = "";
        if (!(args[0] instanceof StringProperty)) {
            throw EvaluationException.create(this.sourceRange, "MSG_FIRST_STRING_ARG_REQ", this.name);
        }
        algorithm = ((StringProperty)args[0]).getValue();
        if (!(args[1] instanceof StringProperty)) {
            throw EvaluationException.create(this.sourceRange, "MSG_SECOND_STRING_ARG_REQ", this.name);
        }
        message = ((StringProperty)args[1]).getValue();
        String digest = "";
        try {
            MessageDigest m = MessageDigest.getInstance(algorithm);
            m.update(message.getBytes(), 0, message.length());
            digest = new BigInteger(1, m.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw EvaluationException.create(this.sourceRange, "MSG_INVALID_DIGEST_ALGORITHM", algorithm);
        }
        return StringProperty.getInstance(digest);
    }
}

