/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.io.File;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class ErrorMessage
extends BuiltInFunction {
    private ErrorMessage(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("error", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_STRING_ARG_REQ", "error");
        }
        return new ErrorMessage(sourceRange, operations);
    }

    public Element execute(Context context) {
        assert (this.ops.length == 1);
        Element result = this.ops[0].execute(context);
        File objectFile = context.getObjectTemplate() != null ? context.getObjectTemplate().source : null;
        try {
            StringProperty sp = (StringProperty)result;
            throw new EvaluationException("user-initiated error: " + sp.getValue(), this.getSourceRange(), objectFile, context.getTraceback(this.getSourceRange()));
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("user-initiated error thrown with non-string argument", this.getSourceRange(), objectFile, context.getTraceback(this.getSourceRange()));
        }
    }

    public void checkRestrictedContext() throws SyntaxException {
        super.checkRestrictedContext();
        throw SyntaxException.create(this.sourceRange, "MSG_RESTRICTED_CONTEXT", this.name);
    }
}

