/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.EscapeUtils;

public final class Escape
extends BuiltInFunction {
    private Escape(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("escape", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        Operation result;
        block6: {
            result = null;
            if (operations.length != 1) {
                throw SyntaxException.create(sourceRange, "MSG_ONE_STRING_ARG_REQ", "escape");
            }
            if (operations[0] instanceof Element) {
                Element e = (Element)operations[0];
                try {
                    try {
                        StringProperty sp = (StringProperty)e;
                        String value = EscapeUtils.escape(sp.getValue());
                        result = StringProperty.getInstance(value);
                        break block6;
                    }
                    catch (ClassCastException cce) {
                        throw new EvaluationException("escape argument is not a string: " + e.getTypeAsString(), sourceRange);
                    }
                }
                catch (EvaluationException ee) {
                    throw SyntaxException.create(sourceRange, ee);
                }
            }
            result = new Escape(sourceRange, operations);
        }
        return result;
    }

    public Element execute(Context context) {
        assert (this.ops.length == 1);
        Element result = this.ops[0].execute(context);
        try {
            String s = ((StringProperty)result).getValue();
            return StringProperty.getInstance(EscapeUtils.escape(s));
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.sourceRange, context);
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("escape argument is not a string: " + result.getTypeAsString(), this.sourceRange);
        }
    }
}

