/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.IllegalFormatException;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Format
extends BuiltInFunction {
    private Format(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("format", sourceRange, operations);
        if (operations.length == 0) {
            throw SyntaxException.create(sourceRange, "MSG_FIRST_STRING_ARG_REQ", this.name);
        }
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        return new Format(sourceRange, operations);
    }

    public Element execute(Context context) {
        assert (this.ops.length > 0);
        Element[] args = this.calculateArgs(context);
        String format = null;
        try {
            format = ((StringProperty)args[0]).getValue();
        }
        catch (ClassCastException cce) {
            throw EvaluationException.create(this.sourceRange, context, "MSG_INVALID_FIRST_ARG_FORMAT", new Object[0]);
        }
        Object[] jargs = new Object[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            Property p = null;
            try {
                p = (Property)args[i];
            }
            catch (ClassCastException cce) {
                throw EvaluationException.create(this.sourceRange, context, "MSG_FORMAT_REQUIRES_PROPERTIES", new Object[0]);
            }
            jargs[i - 1] = p.getValue();
        }
        StringProperty result = null;
        try {
            result = StringProperty.getInstance(String.format(format, jargs));
        }
        catch (IllegalFormatException ife) {
            throw EvaluationException.create(this.sourceRange, context, "MSG_ILLEGAL_FORMAT", ife.getLocalizedMessage());
        }
        assert (result != null);
        return result;
    }
}

