/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.Arrays;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Key
extends BuiltInFunction {
    private Key(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("key", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 2) {
            throw SyntaxException.create(sourceRange, "MSG_TWO_ARGS_REQ", "key");
        }
        return new Key(sourceRange, operations);
    }

    public Element execute(Context context) {
        Element[] args = this.calculateArgs(context);
        assert (args.length == 2);
        HashResource nlist = null;
        int index = 0;
        try {
            nlist = (HashResource)args[0];
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("first argument to key() must be a hash/nlist", this.getSourceRange(), context);
        }
        try {
            long tindex = ((LongProperty)args[1]).getValue();
            if (tindex > Integer.MAX_VALUE) {
                throw new EvaluationException("index exceeds maximum value (2147483647): " + tindex, this.getSourceRange(), context);
            }
            if (tindex < 0L || tindex > (long)(nlist.size() - 1)) {
                throw new EvaluationException("index out of bounds in key(): " + tindex, this.getSourceRange(), context);
            }
            index = (int)tindex;
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("second argument to key() must be a long", this.getSourceRange(), context);
        }
        Object[] keys = nlist.keySet().toArray(new StringProperty[nlist.size()]);
        Arrays.sort(keys);
        return keys[index];
    }
}

