/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.AbstractVariableMatcher;
import org.quattor.pan.dml.functions.StaticMatches;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Matches
extends AbstractVariableMatcher {
    private Matches(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super(sourceRange, "matches", operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length > 0 && operations[1] instanceof StringProperty && (operations.length < 3 || operations[2] instanceof StringProperty)) {
            return StaticMatches.getInstance(sourceRange, operations);
        }
        return new Matches(sourceRange, operations);
    }

    public Element execute(Context context) {
        assert (this.ops.length == 2 || this.ops.length == 3);
        Element[] args = this.calculateArgs(context);
        try {
            String s = ((StringProperty)args[0]).getValue();
            int flags = 0;
            if (this.ops.length == 3) {
                flags = this.convertMatchFlags(args[2]);
            }
            Pattern pattern = this.compilePattern(args[1], flags);
            Matcher matcher = pattern.matcher(s);
            ListResource list = new ListResource();
            if (matcher.find()) {
                int i;
                int lastGroup = 0;
                for (i = 0; i <= matcher.groupCount(); ++i) {
                    if (matcher.group(i) == null) continue;
                    lastGroup = i;
                }
                for (i = 0; i <= lastGroup; ++i) {
                    String group = matcher.group(i);
                    if (group == null) {
                        group = "";
                    }
                    list.put(i, (Element)StringProperty.getInstance(group));
                }
            }
            return list;
        }
        catch (ClassCastException cce) {
            String badtype = "INTERNAL ERROR";
            for (Element e : args) {
                if (e instanceof StringProperty) continue;
                badtype = e.getTypeAsString();
            }
            throw EvaluationException.create(this.sourceRange, context, "MSG_ALL_STRING_ARGS_REQ", this.name, badtype);
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.sourceRange, context);
        }
    }
}

