/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.Exists;
import org.quattor.pan.dml.operators.Variable;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.Template;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Path;

public final class StringExists
extends Exists {
    protected StringExists(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super(sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_ARG_REQ", "exists");
        }
        assert (operations.length == 1);
        if (operations[0] instanceof Variable) {
            throw CompilerError.create("MSG_INVALID_ARG_IN_CONSTRUCTOR", new Object[0]);
        }
        if (operations[0] instanceof Element && !(operations[0] instanceof StringProperty)) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_STRING_OR_IDENTIFIER_REQ", "exists");
        }
        return new StringExists(sourceRange, operations);
    }

    public Element execute(Context context) {
        this.throwExceptionIfCompileTimeContext(context);
        Element result = this.ops[0].execute(context);
        boolean exists = false;
        try {
            String s = ((StringProperty)result).getValue();
            Path path = null;
            try {
                path = new Path(s);
            }
            catch (SyntaxException consumed) {
            }
            catch (EvaluationException consumed) {
                // empty catch block
            }
            if (path != null && !path.isRelative()) {
                exists = context.getElement(path, false) != null;
            } else if (Template.isValidTemplateName(s)) {
                try {
                    Template template = context.localAndGlobalLoad(s, true);
                    exists = template != null;
                }
                catch (EvaluationException consumed) {
                    exists = true;
                }
            } else {
                throw new EvaluationException(MessageUtils.format("MSG_PATH_OR_TPL_NAME_REQ", "exists"), this.getSourceRange(), context);
            }
            return exists ? BooleanProperty.TRUE : BooleanProperty.FALSE;
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_ONE_STRING_OR_IDENTIFIER_REQ", "exists"), this.sourceRange, context);
        }
    }
}

