/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.DoubleProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class ToBoolean
extends BuiltInFunction {
    private ToBoolean(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("to_boolean", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_ARG_REQ", "to_boolean");
        }
        return new ToBoolean(sourceRange, operations);
    }

    public Element execute(Context context) {
        assert (this.ops.length == 1);
        Element result = this.ops[0].execute(context);
        try {
            Element value = null;
            Property property = (Property)result;
            if (property instanceof LongProperty) {
                long x = ((LongProperty)property).getValue();
                value = BooleanProperty.getInstance(x != 0L);
            } else if (property instanceof DoubleProperty) {
                double x = ((DoubleProperty)property).getValue();
                value = BooleanProperty.getInstance(x != 0.0);
            } else if (property instanceof StringProperty) {
                String x = ((StringProperty)property).getValue();
                value = BooleanProperty.getInstance(!"".equals(x) && !"false".equalsIgnoreCase(x));
            } else if (property instanceof BooleanProperty) {
                value = result;
            } else {
                throw CompilerError.create("MSG_UNKNOWN_PROPERTY_TYPE", property.getClass());
            }
            return value;
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("to_boolean argument is not a property: " + result.getTypeAsString(), this.sourceRange, context);
        }
    }
}

