/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.dml.operators.NestedVariable;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Term;

public class SelfNestedVariable
extends NestedVariable {
    public SelfNestedVariable(SourceRange sourceRange, boolean lookupOnly, Operation ... operations) {
        super(sourceRange, "SELF", lookupOnly, operations);
        assert (operations.length > 0);
    }

    public void checkInvalidSelfContext() throws SyntaxException {
        throw SyntaxException.create(this.sourceRange, "MSG_INVALID_SELF_REF_IN_INCLUDE", new Object[0]);
    }

    public Element execute(Context context) {
        if (context.isCompileTimeContext()) {
            throw EvaluationException.create(this.sourceRange, "MSG_INVALID_IN_COMPILE_TIME_CONTEXT", this.getClass().getSimpleName());
        }
        Element result = context.getSelf();
        assert (result != null);
        Term[] terms = null;
        if (!(result instanceof Undef)) {
            try {
                terms = this.calculateTerms(context);
            }
            catch (EvaluationException ee) {
                throw ee.addExceptionInfo(this.getSourceRange(), context);
            }
            try {
                try {
                    result = result.rget(terms, 0, false, false);
                }
                catch (InvalidTermException ite) {
                    if (!this.lookupOnly) {
                        throw new EvaluationException(ite.formatVariableMessage(this.identifier, terms));
                    }
                    result = null;
                }
            }
            catch (EvaluationException ee) {
                throw ee.addExceptionInfo(this.sourceRange, context);
            }
        } else {
            result = null;
        }
        if (result == null && !this.lookupOnly) {
            StringBuilder sb = new StringBuilder(this.identifier);
            if (terms != null) {
                for (Term t : terms) {
                    sb.append("[");
                    sb.append(((Object)t).toString());
                    sb.append("]");
                }
            }
            throw new EvaluationException(MessageUtils.format("MSG_UNDEFINED_VAR", sb.toString()), this.sourceRange, context);
        }
        return result;
    }
}

