/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.dml.operators.SimpleListVariable;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class SelfSimpleListVariable
extends SimpleListVariable {
    public SelfSimpleListVariable(SourceRange sourceRange) {
        super(sourceRange, "SELF");
    }

    public void checkInvalidSelfContext() throws SyntaxException {
        throw SyntaxException.create(this.sourceRange, "MSG_INVALID_SELF_REF_IN_INCLUDE", new Object[0]);
    }

    public Element execute(Context context) {
        if (context.isCompileTimeContext()) {
            throw EvaluationException.create(this.sourceRange, "MSG_INVALID_IN_COMPILE_TIME_CONTEXT", this.getClass().getSimpleName());
        }
        if (context.isSelfFinal()) {
            EvaluationException ee = EvaluationException.create("MSG_CANNOT_MODIFY_SELF", new Object[0]);
            throw ee.addExceptionInfo(this.sourceRange, context);
        }
        Element result = context.getSelf();
        if (result == null) {
            throw CompilerError.create("MSG_SELF_IS_UNDEFINED", new Object[0]);
        }
        if (result instanceof Undef || result instanceof Null) {
            result = new ListResource();
            context.resetSelf(result);
        } else if (result.isProtected()) {
            result = result.writableCopy();
            context.resetSelf(result);
        }
        if (!(result instanceof ListResource)) {
            throw EvaluationException.create(this.sourceRange, "MSG_REFERENCED_VARIABLE_NOT_LIST", result.getTypeAsString());
        }
        return result;
    }
}

