/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.operators.Variable;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public class SimpleVariable
extends Variable {
    private static final Operation[] emptyOps = new Operation[0];

    public SimpleVariable(SourceRange sourceRange, String identifier, boolean lookupOnly) {
        super(sourceRange, identifier, lookupOnly, emptyOps);
        assert (identifier != null);
    }

    public Element execute(Context context) {
        Element result = context.getVariable(this.identifier);
        if (result == null && !this.lookupOnly) {
            throw new EvaluationException(MessageUtils.format("MSG_UNDEFINED_VAR", this.identifier), this.sourceRange, context);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.identifier + "," + this.ops.length + ")";
    }
}

