/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.operators.NestedVariable;
import org.quattor.pan.dml.operators.SelfNestedVariable;
import org.quattor.pan.dml.operators.SelfSimpleVariable;
import org.quattor.pan.dml.operators.SimpleVariable;
import org.quattor.pan.template.SourceRange;

public abstract class Variable
extends AbstractOperation {
    protected final String identifier;
    protected final boolean lookupOnly;

    protected Variable(SourceRange sourceRange, String identifier, boolean lookupOnly, Operation ... operations) {
        super(sourceRange, operations);
        assert (identifier != null);
        this.identifier = identifier;
        this.lookupOnly = lookupOnly;
    }

    public static Variable getInstance(SourceRange sourceRange, String identifier, Operation ... operations) {
        return Variable.getInstance(sourceRange, identifier, false, operations);
    }

    public static Variable getInstance(SourceRange sourceRange, String identifier, boolean lookupOnly, Operation ... operations) {
        return Variable.createSubclass(sourceRange, identifier, lookupOnly, operations);
    }

    public static Variable getInstance(Variable v, boolean lookupOnly) {
        return Variable.createSubclass(v.sourceRange, v.identifier, lookupOnly, v.ops);
    }

    private static Variable createSubclass(SourceRange sourceRange, String identifier, boolean lookupOnly, Operation ... operations) {
        Variable result = null;
        result = operations == null || operations.length == 0 ? ("SELF".equals(identifier) ? new SelfSimpleVariable(sourceRange, lookupOnly) : new SimpleVariable(sourceRange, identifier, lookupOnly)) : ("SELF".equals(identifier) ? new SelfNestedVariable(sourceRange, lookupOnly, operations) : new NestedVariable(sourceRange, identifier, lookupOnly, operations));
        return result;
    }
}

