/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.exceptions;

import java.io.File;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.Template;
import org.quattor.pan.utils.MessageUtils;

public class EvaluationException
extends RuntimeException {
    private SourceRange sourceRange;
    private File file;
    private String traceback;

    public EvaluationException(String message) {
        this(message, (SourceRange)null, (File)null);
    }

    public EvaluationException(String message, SourceRange sourceRange) {
        this(message, sourceRange, (File)null);
    }

    public EvaluationException(String message, SourceRange sourceRange, File file) {
        this(message, sourceRange, file, null);
    }

    public EvaluationException(String message, SourceRange sourceRange, File file, String traceback) {
        super(message);
        this.sourceRange = sourceRange;
        this.file = file;
        this.traceback = traceback;
    }

    public EvaluationException(String message, SourceRange sourceRange, Context context) {
        super(message);
        Template current;
        this.sourceRange = sourceRange;
        if (context != null && (current = context.getCurrentTemplate()) != null) {
            this.file = current.source;
            if (sourceRange != null) {
                this.traceback = context.getTraceback(sourceRange);
            }
        }
    }

    public static EvaluationException create(SourceRange sourceRange, String msgkey, Object ... args) {
        String msg = MessageUtils.format(msgkey, args);
        return new EvaluationException(msg, sourceRange);
    }

    public static EvaluationException create(String msgkey, Object ... args) {
        String msg = MessageUtils.format(msgkey, args);
        return new EvaluationException(msg);
    }

    public static EvaluationException create(SourceRange sourceRange, File file, String msgkey, Object ... args) {
        String msg = MessageUtils.format(msgkey, args);
        return new EvaluationException(msg, sourceRange, file);
    }

    public static EvaluationException create(SourceRange sourceRange, Context context, String msgkey, Object ... args) {
        String msg = MessageUtils.format(msgkey, args);
        return new EvaluationException(msg, sourceRange, context);
    }

    public static EvaluationException create(SourceRange sourceRange, EvaluationException ee) {
        String msg = ee.getSimpleMessage();
        return new EvaluationException(msg, sourceRange);
    }

    public EvaluationException addExceptionInfo(SourceRange sourceRange, File file, String traceback) {
        if (this.sourceRange == null && sourceRange != null) {
            this.sourceRange = sourceRange;
        }
        if (this.file == null && file != null) {
            this.file = file;
        }
        if (this.traceback == null && traceback != null) {
            this.traceback = traceback;
        }
        return this;
    }

    public EvaluationException addExceptionInfo(SourceRange sourceRange, Context context) {
        Template current;
        boolean changed = false;
        if (this.sourceRange == null && sourceRange != null) {
            this.sourceRange = sourceRange;
            changed = true;
        }
        if (this.file == null && context != null && (current = context.getCurrentTemplate()) != null) {
            this.file = current.source;
            changed = true;
        }
        if (changed && sourceRange != null && context != null) {
            this.traceback = context.getTraceback(sourceRange);
        }
        return this;
    }

    public String getSimpleMessage() {
        return super.getMessage();
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder("evaluation error [");
        sb.append(this.file != null ? this.file.toString() : "<unknown>");
        sb.append(":");
        sb.append(this.sourceRange != null ? this.sourceRange.toString() : "<unknown>");
        sb.append("]\n");
        sb.append(super.getMessage());
        sb.append("\n");
        if (this.traceback != null) {
            sb.append(this.traceback);
            sb.append("\n");
        }
        return sb.toString();
    }
}

