/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.exceptions;

import java.io.File;
import java.util.LinkedList;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.type.FullType;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Path;
import org.quattor.pan.utils.Term;

public class ValidationException
extends RuntimeException {
    private File objectTemplate = null;
    private Path path = null;
    private FullType boundType = null;
    private LinkedList<Term> terms = new LinkedList();
    private LinkedList<String> typeStack = new LinkedList();
    private Property value = null;

    private ValidationException(String message) {
        super(message);
    }

    public static ValidationException create(String msgkey, Object ... args) {
        String msg = MessageUtils.format(msgkey, args);
        return new ValidationException(msg);
    }

    public ValidationException setObjectTemplate(File objectTemplate) {
        this.objectTemplate = objectTemplate;
        return this;
    }

    public String getMessage() {
        Path rPath = null;
        if (this.path != null) {
            try {
                rPath = new Path(this.path, this.terms.toArray(new Term[this.terms.size()]));
            }
            catch (SyntaxException consumed) {
                rPath = this.path;
            }
        }
        StringBuilder sb = new StringBuilder("validation error [");
        sb.append(this.objectTemplate != null ? this.objectTemplate.toString() : "<unknown>");
        sb.append("]\n");
        sb.append(super.getMessage());
        sb.append("\n");
        if (rPath != null) {
            sb.append("element path: '");
            sb.append(rPath.toString());
            sb.append("'\n");
        }
        if (this.value != null) {
            sb.append("element value: ");
            sb.append(this.value.toString());
            sb.append("\n");
        }
        for (String s : this.typeStack) {
            sb.append(s);
        }
        if (this.path != null && this.boundType != null) {
            sb.append("path '");
            sb.append(this.path);
            sb.append("' bound to type ");
            sb.append(this.boundType.getTypeName());
            sb.append(" in [");
            sb.append(this.boundType.getSource());
            sb.append(":");
            sb.append(this.boundType.getSourceRange());
            sb.append("]\n");
        }
        if (this.getCause() != null) {
            sb.append("caused by: ");
            sb.append(this.getCause().getMessage());
        }
        return sb.toString();
    }

    public ValidationException setPathTypeAndObject(Path path, FullType type, File objectTemplate) {
        this.path = path;
        this.boundType = type;
        if (this.objectTemplate == null && objectTemplate != null) {
            this.objectTemplate = objectTemplate;
        }
        return this;
    }

    public ValidationException addTerm(Term term) {
        assert (term != null);
        this.terms.addFirst(term);
        return this;
    }

    public ValidationException addTypeToStack(String name, FullType type) {
        String source = "<unknown>";
        String sourceRange = "<unknown>";
        if (type != null) {
            source = type.getSource();
            sourceRange = type.getSourceRange();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("type: '");
        sb.append(name);
        sb.append("' [");
        sb.append(source);
        sb.append(":");
        sb.append(sourceRange);
        sb.append("]\n");
        this.typeStack.add(sb.toString());
        return this;
    }

    public ValidationException setValue(Property property) {
        this.value = property;
        return this;
    }
}

