/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.output;

import java.io.PrintWriter;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.output.XMLFormatterUtils;
import org.quattor.pan.utils.Base64;
import org.quattor.pan.utils.XmlUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlDBFormatter
implements Formatter {
    private static final XmlDBFormatter instance = new XmlDBFormatter();
    private static final String XMLDB_NS = "";
    private static final String suffix = "xml";
    private static final String key = "xmldb";

    private XmlDBFormatter() {
    }

    public static XmlDBFormatter getInstance() {
        return instance;
    }

    public String getFileExtension() {
        return suffix;
    }

    public String getFormatKey() {
        return key;
    }

    public void write(Element root, String rootName, PrintWriter ps) {
        try {
            TransformerHandler handler = XmlUtils.getSaxTransformerHandler();
            handler.setResult(new StreamResult(ps));
            AttributesImpl atts = new AttributesImpl();
            handler.startDocument();
            atts.addAttribute(XMLDB_NS, null, "format", "CDATA", key);
            Integer nbList = 0;
            this.writeChild(handler, atts, ps, root, rootName, nbList);
            handler.endDocument();
        }
        catch (SAXException se) {
            CompilerError error = CompilerError.create("MSG_UNEXPECTED_EXCEPTION_WHILE_WRITING_OUTPUT", new Object[0]);
            error.initCause(se);
            throw error;
        }
    }

    private void writeChild(TransformerHandler handler, AttributesImpl atts, PrintWriter ps, Element node, String name, Integer nbList) throws SAXException {
        String s;
        String tagName = node.getTypeAsString();
        String actualElementName = null;
        String stringContents = null;
        if (nbList != 0) {
            if (!tagName.equals("list") && !tagName.equals("nlist")) {
                atts.addAttribute(XMLDB_NS, null, "type", "CDATA", tagName);
            }
            atts.addAttribute(XMLDB_NS, null, "list", "CDATA", nbList.toString());
        } else if (!tagName.equals("nlist")) {
            atts.addAttribute(XMLDB_NS, null, "type", "CDATA", tagName);
        }
        if (node instanceof StringProperty) {
            s = ((Property)node).toString();
            if (XMLFormatterUtils.isValidXMLString(s)) {
                stringContents = s;
            } else {
                stringContents = Base64.encodeBytes(s.getBytes());
                atts.addAttribute(XMLDB_NS, null, "encoding", "CDATA", "base64");
            }
        }
        if (!tagName.equals("list") || nbList != 0) {
            if (XMLFormatterUtils.isValidXMLName(name)) {
                handler.startElement(XMLDB_NS, null, name, atts);
                actualElementName = name;
            } else {
                String encodedName = XMLFormatterUtils.encodeAsXMLName(name);
                atts.addAttribute(XMLDB_NS, null, "unencoded", "CDATA", name);
                handler.startElement(XMLDB_NS, null, encodedName, atts);
                actualElementName = encodedName;
            }
        }
        atts.clear();
        if (node instanceof HashResource) {
            HashResource hash = (HashResource)node;
            int nblistmem = nbList;
            nbList = 0;
            for (Resource.Entry entry : hash) {
                String nameChild = ((Property)entry.getKey()).toString();
                this.writeChild(handler, atts, ps, (Element)entry.getValue(), nameChild, nbList);
            }
            nbList = nblistmem;
        } else if (node instanceof ListResource) {
            ListResource list = (ListResource)node;
            for (Resource.Entry entry : list) {
                Integer n = nbList;
                Integer n2 = nbList = Integer.valueOf(nbList + 1);
                this.writeChild(handler, atts, ps, (Element)entry.getValue(), name, nbList);
                n = nbList;
                n2 = nbList = Integer.valueOf(nbList - 1);
            }
        } else if (node instanceof StringProperty) {
            handler.characters(stringContents.toCharArray(), 0, stringContents.length());
        } else {
            s = ((Property)node).toString();
            handler.characters(s.toCharArray(), 0, s.length());
        }
        if (!tagName.equals("list") || nbList != 0) {
            handler.endElement(XMLDB_NS, null, actualElementName);
        }
    }
}

