/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.parser;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.quattor.pan.annotation.Annotation;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.exceptions.SystemException;
import org.quattor.pan.parser.ASTBaseTypeSpec;
import org.quattor.pan.parser.ASTFieldSpec;
import org.quattor.pan.parser.ASTStatement;
import org.quattor.pan.parser.ASTTemplate;
import org.quattor.pan.parser.AnnotationToken;
import org.quattor.pan.parser.Node;
import org.quattor.pan.parser.SimpleNode;
import org.quattor.pan.parser.Token;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.XmlUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PanParserAnnotationUtils {
    public static final String PAN_ANNO_NS = "http://quattor.org/pan/annotations";

    public static void printXML(File outputFile, ASTTemplate ast) {
        String templateName = ast.getIdentifier();
        PanParserAnnotationUtils.createDirectories(outputFile, templateName);
        FileWriter writer = null;
        try {
            TransformerHandler handler = XmlUtils.getSaxTransformerHandler();
            writer = new FileWriter(outputFile);
            handler.setResult(new StreamResult(writer));
            handler.startDocument();
            PanParserAnnotationUtils.writeASTNode(handler, ast);
            handler.endDocument();
        }
        catch (SAXException se) {
            CompilerError error = CompilerError.create("MSG_UNEXPECTED_EXCEPTION_WHILE_WRITING_OUTPUT", new Object[0]);
            error.initCause(se);
            throw error;
        }
        catch (IOException e) {
            String msg = MessageUtils.format("MSG_ERROR_WHILE_WRITING_OUTPUT", outputFile);
            SystemException exception = new SystemException(msg);
            throw exception;
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException consumed) {}
            }
        }
    }

    private static void createDirectories(File outputFile, String templateName) {
        File outputDir = outputFile.getParentFile();
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
    }

    private static void writeASTNode(TransformerHandler handler, Node ast) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        String elementName = PanParserAnnotationUtils.getElementInfo(ast, atts);
        if (elementName != null) {
            handler.startElement(PAN_ANNO_NS, null, elementName, atts);
            if (ast instanceof SimpleNode) {
                SimpleNode node = (SimpleNode)ast;
                for (Token t : node.getSpecialTokens()) {
                    PanParserAnnotationUtils.writeAnnotationToken(handler, t);
                }
            }
        }
        int nchild = ast.jjtGetNumChildren();
        for (int i = 0; i < nchild; ++i) {
            PanParserAnnotationUtils.writeASTNode(handler, ast.jjtGetChild(i));
        }
        if (elementName != null) {
            handler.endElement(PAN_ANNO_NS, null, elementName);
        }
    }

    private static String getElementInfo(Node ast, AttributesImpl atts) {
        String elementName = null;
        if (ast instanceof ASTTemplate) {
            ASTTemplate tplNode = (ASTTemplate)ast;
            elementName = "template";
            PanParserAnnotationUtils.addNameAttribute(atts, tplNode.getIdentifier());
            PanParserAnnotationUtils.addSourceRangeAttribute(atts, tplNode);
            PanParserAnnotationUtils.addAttribute(atts, "type", (Object)tplNode.getTemplateType());
        } else if (ast instanceof ASTStatement) {
            ASTStatement node = (ASTStatement)ast;
            ASTStatement.StatementType type = node.getStatementType();
            switch (type) {
                case FUNCTION: 
                case VARIABLE: 
                case TYPE: {
                    elementName = node.getStatementType().toString().toLowerCase();
                    PanParserAnnotationUtils.addNameAttribute(atts, node.getIdentifier());
                    PanParserAnnotationUtils.addSourceRangeAttribute(atts, node);
                    break;
                }
                default: {
                    elementName = null;
                    break;
                }
            }
        } else if (ast instanceof ASTFieldSpec) {
            ASTFieldSpec node = (ASTFieldSpec)ast;
            if (node.getInclude() == null) {
                elementName = "field";
                try {
                    PanParserAnnotationUtils.addNameAttribute(atts, node.getKey());
                }
                catch (SyntaxException consumed) {
                    // empty catch block
                }
                PanParserAnnotationUtils.addSourceRangeAttribute(atts, node);
                PanParserAnnotationUtils.addAttribute(atts, "required", node.isRequired());
            } else {
                elementName = "include";
                PanParserAnnotationUtils.addNameAttribute(atts, node.getInclude());
                PanParserAnnotationUtils.addSourceRangeAttribute(atts, node);
            }
        } else if (ast instanceof ASTBaseTypeSpec) {
            ASTBaseTypeSpec node = (ASTBaseTypeSpec)ast;
            elementName = "basetype";
            PanParserAnnotationUtils.addNameAttribute(atts, node.getIdentifier());
            PanParserAnnotationUtils.addSourceRangeAttribute(atts, node);
            PanParserAnnotationUtils.addAttribute(atts, "extensible", node.isExtensible());
            PanParserAnnotationUtils.addAttribute(atts, "range", node.getRange());
        }
        return elementName;
    }

    private static void writeAnnotationToken(TransformerHandler handler, Token t) throws SAXException {
        if (t instanceof AnnotationToken) {
            AnnotationToken token = (AnnotationToken)t;
            Annotation annotation = (Annotation)token.getValue();
            String name = annotation.getName();
            AttributesImpl atts = new AttributesImpl();
            if (!annotation.isAnonymous()) {
                handler.startElement(PAN_ANNO_NS, null, name, atts);
            }
            for (Annotation.Entry entry : annotation.getEntries()) {
                String elementName = entry.getKey();
                char[] elementContents = entry.getValue().toCharArray();
                handler.startElement(PAN_ANNO_NS, null, elementName, atts);
                handler.characters(elementContents, 0, elementContents.length);
                handler.endElement(PAN_ANNO_NS, null, elementName);
            }
            if (!annotation.isAnonymous()) {
                handler.endElement(PAN_ANNO_NS, null, name);
            }
        }
    }

    public static void addAttribute(AttributesImpl atts, String name, Object value) {
        if (value != null) {
            atts.addAttribute(PAN_ANNO_NS, null, name, "CDATA", value.toString());
        }
    }

    public static void addAttribute(AttributesImpl atts, String name, boolean value) {
        Boolean bvalue = value;
        PanParserAnnotationUtils.addAttribute(atts, name, bvalue);
    }

    public static void addNameAttribute(AttributesImpl atts, Object value) {
        PanParserAnnotationUtils.addAttribute(atts, "name", value);
    }

    public static void addSourceRangeAttribute(AttributesImpl atts, SimpleNode node) {
        SourceRange sourceRange = node.getSourceRange();
        PanParserAnnotationUtils.addAttribute(atts, "source-range", sourceRange);
    }
}

