/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.parser.annotation;

import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.quattor.pan.annotation.Annotation;
import org.quattor.pan.parser.annotation.AnnotationParser;
import org.quattor.pan.parser.annotation.ParseException;
import org.quattor.pan.utils.MessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessor {
    private static final Pattern isKeyPairSyntax = Pattern.compile("^(\\s*)([^=\\n\\r\\f]*)=(.*)", 32);
    private static final Pattern isAnnotationSyntax = Pattern.compile("^\\s*@\\s*([a-zA-Z_0-9\\-\\.]*)\\s*(?:[\\{\\[\\(])(.*)(?:[\\}\\]\\)])\\s*$", 32);

    private AnnotationProcessor() {
    }

    public static Annotation process(String s) throws ParseException {
        List<Annotation.Entry> entries = null;
        Matcher m = isAnnotationSyntax.matcher(s);
        if (m.matches()) {
            assert (m.groupCount() == 2);
            String name = m.group(1);
            String contents = m.group(2);
            entries = AnnotationProcessor.parseAsDesc(contents);
            if (entries == null) {
                StringReader reader = new StringReader(contents);
                AnnotationParser parser = new AnnotationParser(reader);
                try {
                    entries = parser.annotation();
                }
                catch (IllegalArgumentException e) {
                    throw new ParseException(e.getLocalizedMessage());
                }
            }
            if (entries == null) {
                String msg = MessageUtils.format("MSG_INVALID_ANNOTATION_SYNTAX", new Object[0]);
                throw new ParseException(msg);
            }
            try {
                return new Annotation(name, entries);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(e.getLocalizedMessage());
            }
        }
        String msg = MessageUtils.format("MSG_INVALID_ANNOTATION_SYNTAX", new Object[0]);
        throw new ParseException(msg);
    }

    public static List<Annotation.Entry> parseAsDesc(String s) {
        LinkedList<Annotation.Entry> entries = null;
        if (!isKeyPairSyntax.matcher(s).matches()) {
            entries = new LinkedList<Annotation.Entry>();
            entries.add(new Annotation.Entry("desc", s));
        }
        return entries;
    }
}

