/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.repository;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.quattor.pan.repository.FileSystemSourceRepository;
import org.quattor.pan.utils.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemSourceRepositoryWithSessionDir
extends FileSystemSourceRepository {
    private final File sessionDir;
    private final List<File> includeDirectories;

    public FileSystemSourceRepositoryWithSessionDir(File sessionDirectory, List<File> includeDirectories) {
        this.sessionDir = sessionDirectory;
        this.includeDirectories = this.validateAndCopyIncludeDirectories(includeDirectories);
    }

    @Override
    public File lookupText(String name) {
        return this.lookupText(name, emptyRelativePaths);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public File lookupText(String name, List<String> loadpath) {
        assert (loadpath != null);
        assert (loadpath.size() > 0);
        String localName = FileUtils.localizeFilename(name);
        String del = localName + ".del";
        FileHolder fileHolder = new FileHolder();
        Iterator<File> i$ = this.includeDirectories.iterator();
        block8: while (i$.hasNext()) {
            File d = i$.next();
            Iterator<String> i$2 = loadpath.iterator();
            block9: while (true) {
                SearchResult result;
                if (!i$2.hasNext()) continue block8;
                String rpath = i$2.next();
                if (this.sessionDir != null) {
                    result = this.lookupSingleTextFile(this.sessionDir, rpath, del, localName, fileHolder);
                    switch (result) {
                        case SRC_FOUND: {
                            return fileHolder.file;
                        }
                        case DEL_FOUND: {
                            continue block9;
                        }
                    }
                }
                result = this.lookupSingleTextFile(d, rpath, del, localName, fileHolder);
                switch (result) {
                    case SRC_FOUND: {
                        return fileHolder.file;
                    }
                    case DEL_FOUND: {
                        continue block9;
                    }
                }
            }
            break;
        }
        return fileHolder.file;
    }

    @Override
    public File lookupSource(String name) {
        return this.lookupSource(name, emptyRelativePaths);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public File lookupSource(String name, List<String> loadpath) {
        assert (loadpath != null);
        assert (loadpath.size() > 0);
        String localName = FileUtils.localizeFilename(name);
        String del = localName + ".del";
        FileHolder fileHolder = new FileHolder();
        Iterator<File> i$ = this.includeDirectories.iterator();
        block8: while (i$.hasNext()) {
            File d = i$.next();
            Iterator<String> i$2 = loadpath.iterator();
            block9: while (true) {
                SearchResult result;
                if (!i$2.hasNext()) continue block8;
                String rpath = i$2.next();
                if (this.sessionDir != null) {
                    result = this.lookupSingleSourceFile(this.sessionDir, rpath, del, localName, fileHolder);
                    switch (result) {
                        case SRC_FOUND: {
                            return fileHolder.file;
                        }
                        case DEL_FOUND: {
                            continue block9;
                        }
                    }
                }
                result = this.lookupSingleSourceFile(d, rpath, del, localName, fileHolder);
                switch (result) {
                    case SRC_FOUND: {
                        return fileHolder.file;
                    }
                    case DEL_FOUND: {
                        continue block9;
                    }
                }
            }
            break;
        }
        return fileHolder.file;
    }

    private SearchResult lookupSingleSourceFile(File root, String rpath, String delFileName, String name, FileHolder fileHolder) {
        File dir = new File(root, rpath);
        File deletedFileMarker = new File(dir, delFileName);
        if (!deletedFileMarker.exists()) {
            for (String suffix : sourceFileExtensions) {
                File sourceFile = new File(dir, name + suffix);
                if (!sourceFile.exists()) continue;
                fileHolder.file = sourceFile;
                return SearchResult.SRC_FOUND;
            }
            return SearchResult.NOT_FOUND;
        }
        return SearchResult.DEL_FOUND;
    }

    private SearchResult lookupSingleTextFile(File root, String rpath, String delFileName, String name, FileHolder fileHolder) {
        File dir = new File(root, rpath);
        File deletedFileMarker = new File(dir, delFileName);
        if (!deletedFileMarker.exists()) {
            File sourceFile = new File(dir, name);
            if (sourceFile.exists()) {
                fileHolder.file = sourceFile;
                return SearchResult.SRC_FOUND;
            }
            return SearchResult.NOT_FOUND;
        }
        return SearchResult.DEL_FOUND;
    }

    private static class FileHolder {
        public File file = null;

        private FileHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SearchResult {
        SRC_FOUND,
        DEL_FOUND,
        NOT_FOUND;

    }
}

