/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.repository;

import net.jcip.annotations.Immutable;

@Immutable
public class Parameter {
    private final String name;
    private final String value;

    public Parameter(String key, String value) {
        this.name = Parameter.validateName(key);
        this.value = Parameter.validateValue(value);
    }

    public String getKey() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    private static String validateName(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("null is not a valid name");
        }
        if ("".equals(name)) {
            throw new IllegalArgumentException("empty string is not a valid name");
        }
        return name;
    }

    private static String validateValue(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null is not a valid value");
        }
        return value;
    }
}

