/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.statement.AbsoluteAssignmentStatement;
import org.quattor.pan.statement.ConstantAssignmentStatement;
import org.quattor.pan.statement.DeleteAssignmentStatement;
import org.quattor.pan.statement.RelativeAssignmentStatement;
import org.quattor.pan.statement.Statement;
import org.quattor.pan.template.CompileTimeContext;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Path;

public abstract class AssignmentStatement
extends Statement {
    protected final Path path;
    protected final boolean conditional;
    protected final boolean modifiable;

    protected AssignmentStatement(SourceRange sourceRange, Path path, boolean conditional, boolean modifiable) throws SyntaxException {
        super(sourceRange);
        assert (path != null);
        if (path.isExternal()) {
            throw SyntaxException.create(this.getSourceRange(), "MSG_NO_ASSIGNMENT_TO_EXTERNAL_PATH", path);
        }
        this.path = path;
        this.conditional = conditional;
        this.modifiable = modifiable;
    }

    public boolean isAbsolute() {
        return this.path.isAbsolute();
    }

    public boolean isRelative() {
        return this.path.isRelative();
    }

    public static AssignmentStatement createAssignmentStatement(SourceRange sourceRange, Path path, Element value, boolean conditional, boolean modifiable) throws SyntaxException {
        AssignmentStatement stmt = null;
        if (value != null) {
            stmt = !(value instanceof Null) ? new ConstantAssignmentStatement(sourceRange, path, value, conditional, modifiable) : new DeleteAssignmentStatement(sourceRange, path, conditional, modifiable);
        }
        return stmt;
    }

    public static AssignmentStatement createAssignmentStatement(SourceRange sourceRange, Path path, Operation dml, boolean conditional, boolean modifiable) throws SyntaxException {
        Element value = null;
        try {
            CompileTimeContext context = new CompileTimeContext();
            value = context.executeDmlBlock(dml);
        }
        catch (EvaluationException consumed) {
            // empty catch block
        }
        if (value != null) {
            return AssignmentStatement.createAssignmentStatement(sourceRange, path, value, conditional, modifiable);
        }
        if (path.isAbsolute()) {
            return new AbsoluteAssignmentStatement(sourceRange, path, dml, conditional, modifiable);
        }
        if (path.isRelative()) {
            return new RelativeAssignmentStatement(sourceRange, path, dml, conditional, modifiable);
        }
        throw CompilerError.create("MSG_REACHED_IMPOSSIBLE_BRANCH", new Object[0]);
    }
}

