/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.statement.AssignmentStatement;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Path;

public class ConstantAssignmentStatement
extends AssignmentStatement {
    protected final Element value;

    protected ConstantAssignmentStatement(SourceRange sourceRange, Path path, Element value, boolean conditional, boolean modifiable) throws SyntaxException {
        super(sourceRange, path, conditional, modifiable);
        assert (value != null);
        assert (!(value instanceof Null));
        this.value = value.protect();
    }

    public void execute(Context context) throws EvaluationException {
        assert (context != null);
        try {
            boolean setValue = true;
            if (this.conditional) {
                Element self = context.getElement(this.path, false);
                boolean bl = setValue = self == null || self instanceof Undef;
            }
            if (setValue) {
                if (this.path.isAbsolute() && context.isFinal(this.path)) {
                    throw new EvaluationException(context.getFinalReason(this.path), this.getSourceRange());
                }
                context.putElement(this.path, this.value);
            }
            if (this.path.isAbsolute() && !this.modifiable) {
                context.setFinal(this.path);
            }
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.getSourceRange(), context);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.modifiable) {
            sb.append("final ");
        }
        sb.append(this.path.toString());
        if (this.conditional) {
            sb.append(" ?= ");
        } else {
            sb.append(" = ");
        }
        sb.append(this.value.toString());
        sb.append(";");
        return sb.toString();
    }
}

