/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.statement.VariableStatement;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.GlobalVariable;

public class ConstantVariableStatement
extends VariableStatement {
    protected final Element value;

    protected ConstantVariableStatement(SourceRange sourceRange, String name, Element value, boolean conditional, boolean modifiable) throws SyntaxException {
        super(sourceRange, name, conditional, modifiable);
        this.value = value.protect();
    }

    public void execute(Context context) {
        try {
            GlobalVariable variable = context.retrieveGlobalVariable(this.name);
            Element currentValue = variable.getValue();
            assert (currentValue != null);
            if (!this.conditional || currentValue instanceof Undef || currentValue instanceof Null) {
                variable.setValue(this.value);
                variable.setFinalFlag(!this.modifiable);
            } else if (this.conditional && !this.modifiable) {
                variable.setFinalFlag(!this.modifiable);
            }
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.getSourceRange(), context);
        }
    }

    public String toString() {
        return "VARIABLE: " + this.name + ", " + this.conditional + ", " + this.modifiable + ", " + this.value;
    }
}

