/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.statement.Statement;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public class FunctionStatement
extends Statement {
    private final String name;
    private final Operation function;

    public FunctionStatement(SourceRange sourceRange, String name, Operation function) {
        super(sourceRange);
        assert (name != null);
        this.name = name;
        this.function = function;
    }

    public String getName() {
        return this.name;
    }

    public void execute(Context context) {
        try {
            context.setFunction(this.name, this.function, context.getCurrentTemplate(), this.getSourceRange());
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.getSourceRange(), context);
        }
    }

    public String toString() {
        return "FUNCTION: " + this.name + ", " + this.function;
    }
}

