/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import java.util.logging.Level;
import java.util.regex.Pattern;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.statement.ComputedIncludeStatement;
import org.quattor.pan.statement.Statement;
import org.quattor.pan.statement.StaticIncludeStatement;
import org.quattor.pan.template.CompileTimeContext;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.Template;

public abstract class IncludeStatement
extends Statement {
    private static final Pattern identifierPattern = Pattern.compile("^([\\w][\\w+.-]*)(/[\\w+.-]+)*$");

    protected IncludeStatement(SourceRange sourceRange) {
        super(sourceRange);
    }

    static boolean validIdentifier(String name) {
        assert (name != null);
        return identifierPattern.matcher(name).matches();
    }

    public static IncludeStatement newIncludeStatement(SourceRange sourceRange, Operation dml) throws SyntaxException {
        dml.checkInvalidSelfContext();
        Element element = IncludeStatement.runDefaultDml(dml);
        if (element == null) {
            return new ComputedIncludeStatement(sourceRange, dml);
        }
        if (element != null && element instanceof StringProperty) {
            return new StaticIncludeStatement(sourceRange, ((StringProperty)element).getValue());
        }
        if (element instanceof Null || element instanceof Undef) {
            return null;
        }
        throw SyntaxException.create(sourceRange, "MSG_DML_MUST_BE_STRING_NULL_OR_UNDEF", new Object[0]);
    }

    protected void executeWithNamedTemplate(Context context, String name) throws EvaluationException {
        assert (context != null);
        assert (name != null);
        Template template = null;
        boolean runStatic = false;
        try {
            template = context.localLoad(name);
            if (template == null) {
                template = context.globalLoad(name);
                runStatic = true;
            }
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.getSourceRange(), context);
        }
        if (template == null) {
            throw new EvaluationException("failed to load template: " + name, this.getSourceRange());
        }
        Template.TemplateType includeeType = context.getCurrentTemplate().type;
        Template.TemplateType includedType = template.type;
        if (!Template.checkValidInclude(includeeType, includedType)) {
            throw new EvaluationException((Object)((Object)includeeType) + " template cannot include " + (Object)((Object)includedType) + " template", this.getSourceRange());
        }
        context.pushTemplate(template, this.getSourceRange(), Level.INFO, includedType.toString());
        template.execute(runStatic, context);
        context.popTemplate(Level.INFO, includedType.toString());
    }

    private static Element runDefaultDml(Operation dml) throws SyntaxException {
        if (dml == null) {
            return null;
        }
        CompileTimeContext context = new CompileTimeContext();
        Element value = null;
        try {
            value = context.executeDmlBlock(dml);
        }
        catch (EvaluationException consumed) {
            value = null;
        }
        return value;
    }
}

