/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.tasks;

import java.util.Date;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.cache.Valid1Cache;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.tasks.Task;
import org.quattor.pan.tasks.TaskResult;
import org.quattor.pan.tasks.Valid1Result;
import org.quattor.pan.tasks.Valid2Result;
import org.quattor.pan.template.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Valid2Task
extends Task<Valid2Result> {
    private static final Logger taskLogger = CompilerLogging.LoggingType.TASK.logger();

    public Valid2Task(Compiler compiler, String objectName) {
        super(TaskResult.ResultType.VALID2, objectName, new CallImpl(compiler, objectName));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CallImpl
    implements Callable<Valid2Result> {
        private final Compiler compiler;
        private final String objectName;

        public CallImpl(Compiler compiler, String objectName) {
            this.compiler = compiler;
            this.objectName = objectName;
        }

        @Override
        public Valid2Result call() throws Exception {
            Valid1Cache v1cache = this.compiler.getValid1Cache();
            Valid1Result result = (Valid1Result)v1cache.waitForResult(this.objectName);
            Context context = result.getObjectContext();
            taskLogger.log(Level.FINER, "START_VALID2", this.objectName);
            this.validate(context);
            taskLogger.log(Level.FINER, "END_VALID2", this.objectName);
            long timestamp = new Date().getTime();
            return new Valid2Result(context.getRoot().protect(), timestamp, context.getObjectDependencies(), context.getDependencies());
        }

        private void validate(Context context) throws ValidationException {
            TreeSet<String> checkedObjects = new TreeSet<String>();
            Stack<String> queuedObjects = new Stack<String>();
            queuedObjects.addAll(context.getObjectDependencies());
            checkedObjects.add(context.getObjectTemplate().name);
            String currentObject = context.getObjectTemplate().name;
            try {
                while (!queuedObjects.isEmpty()) {
                    currentObject = (String)queuedObjects.pop();
                    if (checkedObjects.contains(currentObject)) continue;
                    Valid1Cache cache = this.compiler.getValid1Cache();
                    Valid1Result result = (Valid1Result)cache.waitForResult(currentObject);
                    Context otherContext = result.getObjectContext();
                    queuedObjects.addAll(otherContext.getObjectDependencies());
                    checkedObjects.add(currentObject);
                }
            }
            catch (EvaluationException ee) {
                ValidationException ve = ValidationException.create("MSG_OBJECT_DEPENDENCY_RAISED_EXCEPTION", currentObject);
                ve.setObjectTemplate(context.getObjectTemplate().source);
                throw ve;
            }
        }
    }
}

