/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.tasks;

import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.cache.Valid2Cache;
import org.quattor.pan.exceptions.SystemException;
import org.quattor.pan.repository.SourceFile;
import org.quattor.pan.tasks.Task;
import org.quattor.pan.tasks.TaskResult;
import org.quattor.pan.tasks.Valid2Result;
import org.quattor.pan.utils.MessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteDepTask
extends Task<TaskResult> {
    private static final Logger taskLogger = CompilerLogging.LoggingType.TASK.logger();

    public WriteDepTask(Compiler compiler, String objectName, File outputDirectory) {
        super(TaskResult.ResultType.DEP, objectName, new CallImpl(compiler, objectName, outputDirectory));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CallImpl
    implements Callable<TaskResult> {
        private final File outputDirectory;
        private final String objectName;
        private final Compiler compiler;

        public CallImpl(Compiler compiler, String objectName, File outputDirectory) {
            this.outputDirectory = outputDirectory;
            this.objectName = objectName;
            this.compiler = compiler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TaskResult call() throws Exception {
            Valid2Cache v2cache = this.compiler.getValid2Cache();
            LinkedList<String> processed = new LinkedList<String>();
            Stack<String> unprocessed = new Stack<String>();
            unprocessed.push(this.objectName);
            TreeSet<SourceFile> allDependencies = new TreeSet<SourceFile>();
            URI odir = this.outputDirectory.toURI();
            URI oname = new URI(this.objectName);
            URI resolvedAbsoluteURI = odir.resolve(oname);
            String resolvedAbsolutePath = resolvedAbsoluteURI.getSchemeSpecificPart() + ".xml.dep";
            File absolutePath = new File(resolvedAbsolutePath);
            File parent = absolutePath.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new SystemException(MessageUtils.format("MSG_CANNOT_CREATE_OUTPUT_DIRECTORY", parent.getAbsolutePath()), parent);
            }
            Long timestamp = null;
            taskLogger.log(Level.FINER, "START_DEPFILE", this.objectName);
            while (!unprocessed.empty()) {
                String objectToProcess = (String)unprocessed.pop();
                if (processed.contains(objectToProcess)) continue;
                processed.add(objectToProcess);
                Valid2Result result = (Valid2Result)v2cache.waitForResult(objectToProcess);
                if (timestamp == null) {
                    timestamp = result.timestamp;
                }
                allDependencies.addAll(result.getDependencies());
                unprocessed.addAll(result.getObjectDependencies());
            }
            PrintStream ps = null;
            try {
                ps = new PrintStream(absolutePath);
                for (SourceFile s : allDependencies) {
                    ps.println(s.toString());
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            taskLogger.log(Level.FINER, "END_DEPFILE", this.objectName);
            if (!absolutePath.setLastModified(timestamp)) {
                // empty if block
            }
            return new TaskResult(TaskResult.ResultType.DEP);
        }
    }
}

