/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.template;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.cache.BuildCache;
import org.quattor.pan.cache.CompileCache;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.ReturnValueException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.repository.SourceFile;
import org.quattor.pan.repository.SourceRepository;
import org.quattor.pan.tasks.BuildResult;
import org.quattor.pan.tasks.CompileResult;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.FunctionMap;
import org.quattor.pan.template.IteratorMap;
import org.quattor.pan.template.LocalVariableMap;
import org.quattor.pan.template.ReadOnlySelfHolder;
import org.quattor.pan.template.SelfHolder;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.Template;
import org.quattor.pan.template.TypeMap;
import org.quattor.pan.type.FullType;
import org.quattor.pan.utils.FinalFlags;
import org.quattor.pan.utils.FunctionDefinition;
import org.quattor.pan.utils.GlobalVariable;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Path;
import org.quattor.pan.utils.SourceLocation;
import org.quattor.pan.utils.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildContext
implements Context {
    private static final String TPL_VAR = "TEMPLATE";
    private static final Logger callLogger = CompilerLogging.LoggingType.CALL.logger();
    private HashResource root = new HashResource();
    private HashResource relativeRoot;
    private final Compiler compiler;
    private final FunctionMap functions;
    private final TypeMap types;
    private final Map<Path, List<FullType>> bindings;
    private final Map<String, GlobalVariable> globalVariables;
    private LocalVariableMap localVariables;
    private final Stack<SourceLocation> templates;
    private Template currentTemplate;
    private final Template objectTemplate;
    private List<String> relativeLoadpaths;
    private SelfHolder self;
    private IteratorMap iteratorMap;
    private final FinalFlags flags;
    private boolean checkObjectDependencies;
    public final int deprecationLevel;
    private static final Template emptyTemplate;
    private Map<String, Template> dependencies;
    private Set<SourceFile> otherDependencies;
    private Set<String> objectDependencies;

    public BuildContext() {
        this(null, emptyTemplate);
    }

    public BuildContext(Compiler compiler, Template objectTemplate) {
        this.compiler = compiler;
        this.deprecationLevel = compiler != null ? compiler.options.deprecationLevel : -1;
        this.functions = new FunctionMap();
        this.types = new TypeMap();
        this.globalVariables = new HashMap<String, GlobalVariable>();
        this.templates = new Stack();
        this.bindings = new TreeMap<Path, List<FullType>>();
        this.dependencies = new HashMap<String, Template>();
        this.otherDependencies = new TreeSet<SourceFile>();
        this.flags = new FinalFlags();
        this.localVariables = new LocalVariableMap();
        this.iteratorMap = new IteratorMap();
        this.objectDependencies = new TreeSet<String>();
        this.self = null;
        assert (objectTemplate != null);
        assert (objectTemplate.type == Template.TemplateType.OBJECT);
        this.objectTemplate = objectTemplate;
        this.dependencies.put(objectTemplate.name, objectTemplate);
        this.objectDependencies.add(objectTemplate.name);
        this.checkObjectDependencies = true;
        this.relativeLoadpaths = new LinkedList<String>();
        this.relativeLoadpaths.add("");
    }

    @Override
    public Template getObjectTemplate() {
        return this.objectTemplate;
    }

    @Override
    public HashResource getRoot() {
        return this.root;
    }

    @Override
    public HashResource restoreRelativeRoot(HashResource previousValue) {
        HashResource value = this.relativeRoot;
        this.relativeRoot = previousValue;
        return value;
    }

    @Override
    public HashResource createRelativeRoot() {
        HashResource oldRelativeRoot = this.relativeRoot;
        this.relativeRoot = new HashResource();
        return oldRelativeRoot;
    }

    @Override
    public Set<SourceFile> getDependencies() {
        TreeSet<SourceFile> sourceFiles = new TreeSet<SourceFile>();
        for (Template t : this.dependencies.values()) {
            sourceFiles.add(t.sourceFile);
        }
        sourceFiles.addAll(this.otherDependencies);
        return Collections.unmodifiableSet(sourceFiles);
    }

    @Override
    public Set<String> getObjectDependencies() {
        return Collections.unmodifiableSet(this.objectDependencies);
    }

    @Override
    public void turnOffObjectDependencyChecking() {
        this.checkObjectDependencies = false;
    }

    @Override
    public Template localLoad(String name) {
        return this.dependencies.get(name);
    }

    @Override
    public Template globalLoad(String name) {
        return this.globalLoad(name, false);
    }

    @Override
    public Template localAndGlobalLoad(String name, boolean lookupOnly) {
        Template template = this.localLoad(name);
        if (template == null) {
            template = this.globalLoad(name, lookupOnly);
        }
        return template;
    }

    @Override
    public Template globalLoad(String name, boolean lookupOnly) {
        if (this.compiler == null) {
            return null;
        }
        SourceRepository repository = this.compiler.getSourceRepository();
        SourceFile source = repository.retrievePanSource(name, this.relativeLoadpaths);
        if (source.isAbsent()) {
            if (lookupOnly) {
                this.otherDependencies.add(source);
                return null;
            }
            throw EvaluationException.create((SourceRange)null, this, "MSG_CANNOT_LOCATE_TEMPLATE", name);
        }
        CompileCache ccache = this.compiler.getCompileCache();
        CompileResult cresult = (CompileResult)ccache.waitForResult(source.getPath().getAbsolutePath());
        Template template = null;
        try {
            template = cresult.template;
            template.templateNameVerification(name);
            if (!lookupOnly) {
                this.dependencies.put(name, template);
                if (template.type == Template.TemplateType.OBJECT) {
                    this.objectDependencies.add(template.name);
                }
            }
        }
        catch (SyntaxException se) {
            if (!lookupOnly) {
                throw new EvaluationException(se.getMessage());
            }
            template = null;
        }
        catch (EvaluationException ee) {
            if (!lookupOnly) {
                throw ee;
            }
            template = null;
        }
        return template;
    }

    @Override
    public SourceFile lookupFile(String name) {
        SourceRepository repository = this.compiler.getSourceRepository();
        SourceFile source = repository.retrieveTxtSource(name, this.relativeLoadpaths);
        this.otherDependencies.add(source);
        return source;
    }

    @Override
    public LocalVariableMap createLocalVariableMap(ListResource argv) {
        LocalVariableMap oldMap = this.localVariables;
        this.localVariables = new LocalVariableMap(argv);
        return oldMap;
    }

    @Override
    public void restoreLocalVariableMap(LocalVariableMap localVariableHolder) {
        this.localVariables = localVariableHolder;
    }

    @Override
    public IteratorMap createIteratorMap() {
        IteratorMap oldIteratorMap = this.iteratorMap;
        this.iteratorMap = new IteratorMap();
        return oldIteratorMap;
    }

    @Override
    public void restoreIteratorMap(IteratorMap iteratorMap) {
        this.iteratorMap = iteratorMap;
    }

    @Override
    public void setObjectAndLoadpath() {
        StringProperty sname = StringProperty.getInstance(this.objectTemplate.name);
        this.setGlobalVariable("OBJECT", sname, true);
        this.setGlobalVariable("LOADPATH", new ListResource(), false);
    }

    @Override
    public FunctionDefinition getFunction(String name) {
        return this.functions.get(name);
    }

    @Override
    public void setFunction(String name, Operation function, Template template, SourceRange sourceRange) throws EvaluationException {
        this.functions.put(name, function, template, sourceRange);
    }

    @Override
    public Map<Path, List<FullType>> getBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }

    @Override
    public void setBinding(Path path, FullType fullType, Template template, SourceRange sourceRange) {
        assert (path != null);
        assert (path.isAbsolute());
        assert (fullType != null);
        try {
            fullType.verifySubtypesDefined(this.types);
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(sourceRange, template.source, this.getTraceback(sourceRange));
        }
        List<FullType> list = this.bindings.get(path);
        if (list == null) {
            list = new LinkedList<FullType>();
            this.bindings.put(path, list);
        }
        assert (list != null);
        list.add(fullType);
    }

    @Override
    public FullType getFullType(String name) {
        return this.types.get(name);
    }

    @Override
    public void setFullType(String name, FullType fullType, Template template, SourceRange sourceRange) throws EvaluationException {
        this.types.put(name, fullType, template, sourceRange);
    }

    @Override
    public void setGlobalVariable(String name, Element value) {
        assert (name != null);
        GlobalVariable gvar = this.globalVariables.get(name);
        gvar.setValue(value);
    }

    @Override
    public void setGlobalVariable(String name, GlobalVariable variable) {
        assert (name != null);
        if (variable != null) {
            this.globalVariables.put(name, variable);
        } else {
            this.globalVariables.remove(name);
        }
    }

    @Override
    public GlobalVariable replaceGlobalVariable(String name, Element value, boolean finalFlag) {
        assert (name != null);
        GlobalVariable oldVariable = this.globalVariables.get(name);
        GlobalVariable newVariable = new GlobalVariable(finalFlag, value);
        this.globalVariables.put(name, newVariable);
        return oldVariable;
    }

    @Override
    public void setGlobalVariable(String name, Element value, boolean finalFlag) {
        assert (name != null);
        if (this.globalVariables.containsKey(name)) {
            GlobalVariable gvar = this.globalVariables.get(name);
            gvar.setValue(value);
            gvar.setFinalFlag(finalFlag);
        } else if (value != null) {
            GlobalVariable gvar = new GlobalVariable(finalFlag, value);
            this.globalVariables.put(name, gvar);
        }
    }

    @Override
    public void setIterator(Resource resource, Resource.Iterator iterator) {
        this.iteratorMap.put(resource, iterator);
    }

    @Override
    public Resource.Iterator getIterator(Resource resource) {
        return this.iteratorMap.get(resource);
    }

    @Override
    public void removeGlobalVariable(String name) {
        assert (name != null);
        this.globalVariables.remove(name);
    }

    @Override
    public Element getGlobalVariable(String name) {
        GlobalVariable gvar = this.globalVariables.get(name);
        return gvar != null ? gvar.getValue() : null;
    }

    @Override
    public GlobalVariable retrieveGlobalVariable(String name) {
        GlobalVariable variable = this.globalVariables.get(name);
        if (variable == null) {
            variable = new GlobalVariable(false, Undef.VALUE);
            this.globalVariables.put(name, variable);
        }
        return variable;
    }

    @Override
    public void pushTemplate(Template template, SourceRange sourceRange, Level logLevel, String logMessage) {
        SourceLocation location = new SourceLocation(this.currentTemplate, sourceRange);
        this.templates.push(location);
        this.currentTemplate = template;
        callLogger.log(logLevel, "ENTER", new Object[]{logMessage, this.currentTemplate.name, this.currentTemplate.source});
        if (this.templates.size() > this.getCallLimit()) {
            this.popTemplate(Level.INFO, logMessage);
            throw new EvaluationException("call depth limit (" + this.getCallLimit() + ") exceeded", sourceRange, this);
        }
    }

    @Override
    public void popTemplate(Level logLevel, String logMessage) {
        callLogger.log(logLevel, "EXIT", new Object[]{logMessage, this.currentTemplate.name});
        SourceLocation location = this.templates.pop();
        this.currentTemplate = location.template;
    }

    @Override
    public void printTraceback(SourceRange sourceRange) {
        System.err.println(this.getTraceback(sourceRange));
    }

    @Override
    public String getTraceback(SourceRange sourceRange) {
        SourceLocation[] locations = this.templates.toArray(new SourceLocation[this.templates.size()]);
        StringBuilder sb = new StringBuilder();
        sb.append(">>> call stack trace \n");
        sb.append(">>> ");
        sb.append(new SourceLocation(this.currentTemplate, sourceRange).toString());
        sb.append("\n");
        for (int i = locations.length - 1; i >= 0; --i) {
            sb.append(">>> ");
            sb.append(locations[i].toString());
            sb.append("\n");
        }
        sb.append(">>> ====================\n\n");
        return sb.toString();
    }

    @Override
    public void setCurrentTemplate(Template template) {
        this.currentTemplate = template;
    }

    @Override
    public Template getCurrentTemplate() {
        return this.currentTemplate;
    }

    @Override
    public Element getElement(Path path) throws EvaluationException, ValidationException {
        return this.getElement(path, true);
    }

    @Override
    public Element getElement(Path path, boolean errorIfNotFound) throws EvaluationException {
        Element node = null;
        switch (path.getType()) {
            case ABSOLUTE: {
                node = this.root;
                break;
            }
            case RELATIVE: {
                if (this.relativeRoot != null) {
                    node = this.relativeRoot;
                    break;
                }
                throw new EvaluationException("relative path ('" + path + "') cannot be used to retrieve element in configuration");
            }
            case EXTERNAL: {
                String myObject = this.objectTemplate.name;
                String externalObject = path.getAuthority();
                if (myObject.equals(externalObject)) {
                    node = this.root;
                    break;
                }
                Template externalTemplate = this.localAndGlobalLoad(externalObject, !errorIfNotFound);
                if (externalTemplate != null && !errorIfNotFound) {
                    this.dependencies.put(externalObject, externalTemplate);
                    this.objectDependencies.add(externalObject);
                } else if (externalTemplate == null) {
                    if (errorIfNotFound) {
                        throw new EvaluationException("object template " + externalObject + " could not be found", null);
                    }
                    return null;
                }
                BuildCache bcache = this.compiler.getBuildCache();
                if (this.checkObjectDependencies) {
                    bcache.setDependency(myObject, externalObject);
                }
                BuildResult result = (BuildResult)bcache.waitForResult(externalObject);
                node = result.getRoot();
            }
        }
        assert (node != null);
        try {
            node = ((Element)node).rget(path.getTerms(), 0, node.isProtected(), !errorIfNotFound);
        }
        catch (InvalidTermException ite) {
            throw new EvaluationException(ite.formatMessage(path));
        }
        if (!errorIfNotFound || node != null) {
            return node;
        }
        throw new EvaluationException(MessageUtils.format("MSG_NO_VALUE_FOR_PATH", path.toString()));
    }

    @Override
    public void putElement(Path path, Element value) {
        if (path.isAbsolute() || path.isRelative()) {
            HashResource node;
            Term[] terms = path.getTerms();
            int nterms = terms.length;
            if (path.isAbsolute() && nterms == 0) {
                if (value == null) {
                    throw new EvaluationException("cannot set root element to null");
                }
                try {
                    this.root = (HashResource)value;
                    return;
                }
                catch (ClassCastException cce) {
                    throw new EvaluationException("root element cannot be replaced by element of type " + value.getTypeAsString());
                }
            }
            if (path.isRelative()) {
                if (this.relativeRoot == null) {
                    throw CompilerError.create("MSG_INVALID_ATTEMPT_TO_SET_RELATIVE_PATH", path.toString());
                }
                if (nterms == 0) {
                    throw CompilerError.create("MSG_INVALID_EMPTY_RELATIVE_PATH", new Object[0]);
                }
            }
            HashResource hashResource = node = path.isAbsolute() ? this.root : this.relativeRoot;
            assert (node != null) : "root or relativeRoot is unexpectedly null";
            if (node.isProtected()) {
                HashResource unprotected;
                node = unprotected = (HashResource)node.writableCopy();
                if (path.isAbsolute()) {
                    this.root = unprotected;
                } else {
                    this.relativeRoot = unprotected;
                }
            }
            try {
                node.rput(terms, 0, value);
            }
            catch (InvalidTermException ite) {
                throw new EvaluationException(ite.formatMessage(path));
            }
        } else {
            throw CompilerError.create("MSG_INVALID_ATTEMPT_TO_SET_EXTERNAL_PATH", path.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element executeDmlBlock(Operation dml) {
        boolean setTemplate;
        Element result = null;
        LocalVariableMap oldVariables = this.createLocalVariableMap(null);
        IteratorMap oldIterators = this.createIteratorMap();
        boolean bl = setTemplate = this.getGlobalVariable(TPL_VAR) == null;
        if (setTemplate) {
            Template current = this.getCurrentTemplate();
            if (current != null) {
                StringProperty tname = StringProperty.getInstance(current.name);
                this.setGlobalVariable(TPL_VAR, tname, true);
            } else {
                setTemplate = false;
            }
        }
        try {
            result = dml.execute(this);
        }
        catch (ReturnValueException rve) {
            result = rve.getElement();
        }
        finally {
            if (setTemplate) {
                this.removeGlobalVariable(TPL_VAR);
            }
            this.restoreLocalVariableMap(oldVariables);
            this.restoreIteratorMap(oldIterators);
        }
        return result;
    }

    @Override
    public boolean executeDmlValidationBlock(Operation dml, Element self) throws ValidationException {
        Element result = null;
        LocalVariableMap oldVariables = this.createLocalVariableMap(null);
        IteratorMap oldIterators = this.createIteratorMap();
        ReadOnlySelfHolder selfHolder = new ReadOnlySelfHolder(self);
        this.initializeSelfHolder(selfHolder);
        try {
            result = dml.execute(this);
        }
        catch (ReturnValueException rve) {
            result = rve.getElement();
        }
        catch (EvaluationException ee) {
            File objectFile = this.objectTemplate != null ? this.objectTemplate.source : null;
            ValidationException ve = ValidationException.create("MSG_VALIDATION_FAILED_BECAUSE_OF_EXCEPTION", new Object[0]);
            ve.setObjectTemplate(objectFile);
            ve.initCause(ee);
            throw ve;
        }
        finally {
            this.clearSelf();
            this.restoreLocalVariableMap(oldVariables);
            this.restoreIteratorMap(oldIterators);
        }
        try {
            BooleanProperty bresult = (BooleanProperty)result;
            return bresult.getValue();
        }
        catch (ClassCastException cce) {
            File objectFile = this.objectTemplate != null ? this.objectTemplate.source : null;
            ValidationException ve = ValidationException.create("MSG_INVALID_VALIDATION_FUNCTION_RETURN_TYPE", result.getTypeAsString());
            throw ve.setObjectTemplate(objectFile);
        }
    }

    @Override
    public Element getLocalVariable(String name) {
        return this.localVariables.get(name);
    }

    @Override
    public Element getVariable(String name) {
        Element result = this.localVariables.get(name);
        if (result == null) {
            result = this.getGlobalVariable(name);
        }
        return result;
    }

    @Override
    public Element dereferenceVariable(String name, boolean lookupOnly, Term[] terms) throws InvalidTermException {
        boolean duplicate = false;
        Element result = this.localVariables.get(name);
        if (result == null) {
            duplicate = true;
            result = this.getGlobalVariable(name);
        }
        if (result != null) {
            result = !(result instanceof Undef) ? result.rget(terms, 0, false, lookupOnly) : null;
        }
        if (duplicate && result != null) {
            result = result.duplicate();
        }
        return result;
    }

    @Override
    public void setLocalVariable(String name, Element value) throws EvaluationException {
        assert (name != null);
        if (this.globalVariables.containsKey(name)) {
            throw new EvaluationException(MessageUtils.format("MSG_CANNOT_MODIFY_GLOBAL_VARIABLE_FROM_DML", name));
        }
        this.localVariables.put(name, value);
    }

    @Override
    public void setLocalVariable(String name, Term[] terms, Element value) throws EvaluationException {
        assert (name != null);
        if (this.globalVariables.containsKey(name)) {
            throw new EvaluationException(MessageUtils.format("MSG_CANNOT_MODIFY_GLOBAL_VARIABLE_FROM_DML", name));
        }
        if (terms == null || terms.length == 0) {
            this.setLocalVariable(name, value);
        } else {
            Element var = this.getLocalVariable(name);
            if (var != null && var.isProtected()) {
                var = var.writableCopy();
                this.setLocalVariable(name, var);
            }
            if (var == null || var instanceof Undef) {
                Term term = terms[0];
                var = term.isKey() ? new HashResource() : new ListResource();
                this.setLocalVariable(name, var);
            }
            assert (var != null);
            try {
                var.rput(terms, 0, value);
            }
            catch (InvalidTermException ite) {
                throw new EvaluationException(ite.formatVariableMessage(name, terms));
            }
        }
    }

    @Override
    public int getCallLimit() {
        return this.compiler != null ? this.compiler.options.callDepthLimit : 50;
    }

    @Override
    public int getIterationLimit() {
        return this.compiler != null ? this.compiler.options.iterationLimit : 1000;
    }

    @Override
    public boolean isFinal(Path p) {
        return this.flags.isFinal(p);
    }

    @Override
    public String getFinalReason(Path p) {
        return this.flags.getFinalReason(p);
    }

    @Override
    public void setFinal(Path p) {
        this.flags.setFinal(p);
    }

    @Override
    public boolean isCompileTimeContext() {
        return false;
    }

    @Override
    public void initializeSelfHolder(SelfHolder selfHolder) {
        this.self = selfHolder;
    }

    @Override
    public boolean isSelfFinal() {
        try {
            return this.self.isUnmodifiable();
        }
        catch (NullPointerException e) {
            throw CompilerError.create("MSG_SELF_IS_UNDEFINED", new Object[0]);
        }
    }

    @Override
    public Element getSelf() {
        try {
            return this.self.getElement();
        }
        catch (NullPointerException e) {
            throw CompilerError.create("MSG_SELF_IS_UNDEFINED", new Object[0]);
        }
    }

    @Override
    public void clearSelf() {
        this.self = null;
    }

    @Override
    public SelfHolder saveSelf() {
        SelfHolder saved = this.self;
        this.self = null;
        return saved;
    }

    @Override
    public void restoreSelf(SelfHolder self) {
        this.self = self;
    }

    @Override
    public void resetSelf(Element newValue) {
        this.self.setElement(newValue);
    }

    @Override
    public void setRelativeLoadpaths(List<String> rpaths) {
        this.relativeLoadpaths = rpaths;
    }

    @Override
    public List<String> getRelativeLoadpaths() {
        return this.relativeLoadpaths;
    }

    @Override
    public int getDeprecationLevel() {
        return this.deprecationLevel;
    }

    @Override
    public boolean getFailOnWarn() {
        return this.compiler.options.failOnWarn;
    }

    static {
        try {
            emptyTemplate = new Template("empty");
        }
        catch (SyntaxException se) {
            throw CompilerError.create("MSG_CANNOT_CREATE_EMPTY_TEMPLATE", new Object[0]);
        }
    }
}

