/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.template;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.repository.SourceFile;
import org.quattor.pan.statement.AssignmentStatement;
import org.quattor.pan.statement.BindStatement;
import org.quattor.pan.statement.FunctionStatement;
import org.quattor.pan.statement.IncludeStatement;
import org.quattor.pan.statement.Statement;
import org.quattor.pan.statement.TypeStatement;
import org.quattor.pan.statement.VariableStatement;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    private static final boolean[][] allowedIncludes;
    public static final Pattern validTemplateNameChars;
    public final SourceFile sourceFile;
    public final File source;
    public final String name;
    public final TemplateType type;
    private final Statement[] staticStatements;
    private final Statement[] normalStatements;
    private static final Statement[] emptyStatements;

    public Template(String name) throws SyntaxException {
        this(null, null, TemplateType.OBJECT, name, null);
    }

    public Template(File source, SourceRange sourceRange, TemplateType type, String name, List<Statement> statements) throws SyntaxException {
        AssignmentStatement stmt;
        try {
            this.sourceFile = new SourceFile(name, true, source);
        }
        catch (IllegalArgumentException e) {
            throw new SyntaxException(e.getMessage(), sourceRange, source);
        }
        this.name = this.sourceFile.getName();
        this.source = this.sourceFile.getPath();
        assert (type != null);
        this.type = type;
        if (statements == null) {
            statements = new LinkedList<Statement>();
        }
        ArrayList<Statement> ss = new ArrayList<Statement>(statements.size());
        ArrayList<Statement> ns = new ArrayList<Statement>(statements.size());
        for (Statement s : statements) {
            ss.add(s);
            if (type == TemplateType.UNIQUE || type == TemplateType.DECLARATION || s instanceof FunctionStatement || s instanceof TypeStatement || s instanceof BindStatement) continue;
            ns.add(s);
        }
        this.staticStatements = ss.size() > 0 ? ss.toArray(new Statement[ss.size()]) : emptyStatements;
        this.normalStatements = ss.size() == ns.size() ? this.staticStatements : (ns.size() > 0 ? ns.toArray(new Statement[ns.size()]) : emptyStatements);
        if (type == TemplateType.DECLARATION) {
            for (Statement s : this.staticStatements) {
                if (s instanceof FunctionStatement || s instanceof TypeStatement || s instanceof IncludeStatement || s instanceof BindStatement || s instanceof VariableStatement) continue;
                throw SyntaxException.create(s.getSourceRange(), source, "MSG_INVALID_STMT_IN_DECL_TPL", new Object[0]);
            }
        }
        if (type == TemplateType.STRUCTURE) {
            for (Statement s : this.staticStatements) {
                if (s instanceof VariableStatement || s instanceof BindStatement || s instanceof FunctionStatement || s instanceof TypeStatement) {
                    throw SyntaxException.create(s.getSourceRange(), source, "MSG_INVALID_STATEMENT_IN_STRUCT_TPL", new Object[0]);
                }
                if (!(s instanceof AssignmentStatement) || !(stmt = (AssignmentStatement)s).isAbsolute()) continue;
                throw SyntaxException.create(s.getSourceRange(), source, "MSG_ONLY_REL_ASSIGNMENT_ALLOWED", new Object[0]);
            }
        }
        if (type != TemplateType.STRUCTURE && type != TemplateType.DECLARATION) {
            for (Statement s : this.staticStatements) {
                if (!(s instanceof AssignmentStatement) || !(stmt = (AssignmentStatement)s).isRelative()) continue;
                throw SyntaxException.create(s.getSourceRange(), source, "MSG_ONLY_ABS_ASSIGNMENT_ALLOWED", new Object[0]);
            }
        }
        HashMap<String, SourceRange> mdefns = new HashMap<String, SourceRange>();
        for (Statement s : this.staticStatements) {
            SourceRange oldvalue;
            if (s instanceof TypeStatement) {
                TypeStatement ts = (TypeStatement)s;
                oldvalue = mdefns.put("T$" + ts.getName(), ts.getSourceRange());
                if (oldvalue == null) continue;
                throw SyntaxException.create(ts.getSourceRange(), source, "MSG_MULTIPLY_DEFINED_TYPE", ts.getName(), oldvalue);
            }
            if (!(s instanceof FunctionStatement)) continue;
            FunctionStatement fs = (FunctionStatement)s;
            oldvalue = mdefns.put("F$" + fs.getName(), fs.getSourceRange());
            if (oldvalue == null) continue;
            throw SyntaxException.create(fs.getSourceRange(), source, "MSG_MULTIPLY_DEFINED_FUNCTION", fs.getName(), oldvalue);
        }
        if ((type == TemplateType.UNIQUE || type == TemplateType.DECLARATION) && this.normalStatements.length != 0) {
            throw CompilerError.create("MSG_TEMPLATE_CONTAINS_NON_STATIC_STATEMENTS", new Object[0]);
        }
    }

    public static boolean isValidTemplateName(String name) {
        if (!validTemplateNameChars.matcher(name).matches()) {
            return false;
        }
        for (String t : name.split("/")) {
            if (!"".equals(t) && !t.startsWith(".")) continue;
            return false;
        }
        return true;
    }

    public void execute(boolean runStatic, Context context) {
        for (Statement s : runStatic ? this.staticStatements : this.normalStatements) {
            s.execute(context);
        }
    }

    public static boolean checkValidInclude(TemplateType includeeType, TemplateType includedType) {
        return allowedIncludes[includeeType.ordinal()][includedType.ordinal()];
    }

    public void templateNameVerification(String expectedName) throws SyntaxException {
        if (!this.name.equals(expectedName)) {
            throw SyntaxException.create(null, this.source, "MSG_MISNAMED_TPL", expectedName);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.toString());
        sb.append(" template ");
        sb.append(this.name);
        sb.append("\n");
        sb.append("Source: ");
        sb.append(this.source.toString());
        sb.append("\n");
        for (Statement s : this.staticStatements) {
            sb.append(s.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    static {
        TemplateType[] allTypes = TemplateType.values();
        int maxIndex = 0;
        for (TemplateType t : allTypes) {
            int ordinal = t.ordinal();
            if (ordinal <= maxIndex) continue;
            maxIndex = ordinal;
        }
        allowedIncludes = new boolean[maxIndex + 1][maxIndex + 1];
        for (TemplateType t1 : allTypes) {
            for (TemplateType t2 : allTypes) {
                Template.allowedIncludes[t1.ordinal()][t2.ordinal()] = false;
            }
        }
        Template.allowedIncludes[TemplateType.OBJECT.ordinal()][TemplateType.ORDINARY.ordinal()] = true;
        Template.allowedIncludes[TemplateType.OBJECT.ordinal()][TemplateType.DECLARATION.ordinal()] = true;
        Template.allowedIncludes[TemplateType.OBJECT.ordinal()][TemplateType.UNIQUE.ordinal()] = true;
        Template.allowedIncludes[TemplateType.ORDINARY.ordinal()][TemplateType.ORDINARY.ordinal()] = true;
        Template.allowedIncludes[TemplateType.ORDINARY.ordinal()][TemplateType.DECLARATION.ordinal()] = true;
        Template.allowedIncludes[TemplateType.ORDINARY.ordinal()][TemplateType.UNIQUE.ordinal()] = true;
        Template.allowedIncludes[TemplateType.UNIQUE.ordinal()][TemplateType.ORDINARY.ordinal()] = true;
        Template.allowedIncludes[TemplateType.UNIQUE.ordinal()][TemplateType.DECLARATION.ordinal()] = true;
        Template.allowedIncludes[TemplateType.UNIQUE.ordinal()][TemplateType.UNIQUE.ordinal()] = true;
        Template.allowedIncludes[TemplateType.STRUCTURE.ordinal()][TemplateType.DECLARATION.ordinal()] = true;
        Template.allowedIncludes[TemplateType.STRUCTURE.ordinal()][TemplateType.STRUCTURE.ordinal()] = true;
        Template.allowedIncludes[TemplateType.DECLARATION.ordinal()][TemplateType.DECLARATION.ordinal()] = true;
        validTemplateNameChars = Pattern.compile("^[\\w\\./+-]+$");
        emptyStatements = new Statement[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TemplateType {
        ORDINARY,
        OBJECT,
        DECLARATION,
        STRUCTURE,
        UNIQUE;

    }
}

