/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.DoubleProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.NumberProperty;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.type.ConcretePrimitiveType;
import org.quattor.pan.type.FullType;
import org.quattor.pan.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseType
extends Type {
    private static final Map<String, FullType> builtins;

    public static Map<String, FullType> getBuiltinTypes() {
        return builtins;
    }

    public BaseType(String source, SourceRange sourceRange) {
        super(source, sourceRange);
    }

    static {
        HashMap<String, FullType> types = new HashMap<String, FullType>();
        types.put("boolean", new FullType(new ConcretePrimitiveType("boolean", BooleanProperty.class)));
        types.put("double", new FullType(new ConcretePrimitiveType("double", DoubleProperty.class)));
        types.put("element", new FullType(new ConcretePrimitiveType("element", Element.class)));
        types.put("nlist", new FullType(new ConcretePrimitiveType("nlist", HashResource.class)));
        types.put("list", new FullType(new ConcretePrimitiveType("list", ListResource.class)));
        types.put("long", new FullType(new ConcretePrimitiveType("long", LongProperty.class)));
        types.put("number", new FullType(new ConcretePrimitiveType("number", NumberProperty.class)));
        types.put("property", new FullType(new ConcretePrimitiveType("property", Property.class)));
        types.put("resource", new FullType(new ConcretePrimitiveType("resource", Resource.class)));
        types.put("string", new FullType(new ConcretePrimitiveType("string", StringProperty.class)));
        builtins = Collections.unmodifiableMap(types);
    }
}

