/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.type;

import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.type.PrimitiveType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcretePrimitiveType
extends PrimitiveType {
    private final String name;
    private final Class<? extends Element> elementType;

    public ConcretePrimitiveType(String name, Class<? extends Element> elementType) {
        assert (name != null);
        assert (elementType != null);
        this.name = name;
        this.elementType = elementType;
    }

    @Override
    public void validate(Context context, Element self) throws ValidationException {
        try {
            this.elementType.cast(self);
        }
        catch (ClassCastException cce) {
            ValidationException ve = ValidationException.create("MSG_MISMATCHED_TYPES", this.name, self.getTypeAsString());
            if (self instanceof Property) {
                ve.setValue((Property)self);
            }
            throw ve;
        }
    }
}

