/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.type;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.TypeMap;
import org.quattor.pan.type.BaseType;
import org.quattor.pan.type.Type;

public class FullType
extends Type {
    private final BaseType baseType;
    private final Element defaultValue;
    private final Operation dml;

    public FullType(BaseType baseType) {
        this(null, null, baseType, null, null);
    }

    public FullType(String source, SourceRange sourceRange, BaseType baseType, Element defaultValue, Operation dml) {
        super(source, sourceRange);
        assert (baseType != null);
        this.baseType = baseType;
        this.defaultValue = defaultValue;
        this.dml = dml;
    }

    public Element findDefault(Context context) {
        return this.defaultValue != null ? this.defaultValue : this.baseType.findDefault(context);
    }

    public void validate(Context context, Element self) throws ValidationException {
        if (self == null) {
            throw ValidationException.create("MSG_NONEXISTANT_ELEMENT", new Object[0]);
        }
        this.baseType.validate(context, self);
        if (this.dml != null && !context.executeDmlValidationBlock(this.dml, self)) {
            ValidationException ve = ValidationException.create("MSG_USER_VALIDATION_FAILED", new Object[0]);
            if (self instanceof Property) {
                ve.setValue((Property)self);
            }
            throw ve;
        }
    }

    public void validateAsIncludedType(Context context, Element self) throws ValidationException {
        if (self == null) {
            throw ValidationException.create("MSG_NONEXISTANT_ELEMENT", new Object[0]);
        }
        this.baseType.validateAsIncludedType(context, self);
        if (this.dml != null && !context.executeDmlValidationBlock(this.dml, self)) {
            ValidationException ve = ValidationException.create("MSG_USER_VALIDATION_FAILED", new Object[0]);
            if (self instanceof Property) {
                ve.setValue((Property)self);
            }
            throw ve;
        }
    }

    public Element setDefaults(Context context, Element self) throws EvaluationException {
        assert (context != null);
        assert (self != null);
        return this.baseType.setDefaults(context, self);
    }

    public void verifySubtypesDefined(TypeMap types) {
        this.baseType.verifySubtypesDefined(types);
    }

    public BaseType getBaseType() {
        return this.baseType;
    }

    public String getTypeName() {
        return this.baseType.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.baseType + ")\ndefault value=" + this.defaultValue + "\nwith=" + this.dml + "\n";
    }
}

