/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.type;

import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.type.BaseType;
import org.quattor.pan.type.CompositeType;
import org.quattor.pan.utils.Range;
import org.quattor.pan.utils.Term;

public class HashType
extends CompositeType {
    public HashType(String source, SourceRange sourceRange, BaseType baseType, Range range) {
        super(source, sourceRange, baseType, range);
    }

    public Element findDefault(Context context) {
        return null;
    }

    public Element setDefaults(Context context, Element self) throws EvaluationException {
        assert (context != null);
        assert (self != null);
        HashResource replacement = null;
        try {
            HashResource nlist = (HashResource)self;
            for (Term t : nlist.keySet()) {
                Element child = nlist.get(t);
                Element newValue = this.baseType.setDefaults(context, child);
                if (newValue == null) continue;
                if (replacement == null) {
                    replacement = (HashResource)nlist.writableCopy();
                }
                replacement.put(t, newValue);
            }
        }
        catch (ClassCastException cce) {
        }
        catch (InvalidTermException ite) {
            throw CompilerError.create("MSG_INVALID_KEY_OR_INDEX", new Object[0]);
        }
        return replacement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(Context context, Element self) throws ValidationException {
        try {
            HashResource nlist = (HashResource)self;
            if (this.range != null) {
                nlist.checkRange(this.range);
            }
            for (Term t : nlist.keySet()) {
                try {
                    Element child = nlist.get(t);
                    this.baseType.validate(context, child);
                }
                catch (ValidationException ve) {
                    throw ve.addTerm(t);
                }
                catch (InvalidTermException ite) {
                    throw CompilerError.create("MSG_INVALID_KEY_OR_INDEX", new Object[0]);
                    return;
                }
            }
        }
        catch (ClassCastException cce) {
            throw ValidationException.create("MSG_MISMATCHED_TYPES", "nlist", self.getTypeAsString());
        }
    }

    public String toString() {
        if (this.range == null) {
            return this.baseType.toString() + "{}";
        }
        return this.baseType.toString() + "{" + this.range + "}";
    }
}

