/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.utils;

import org.quattor.pan.dml.data.Element;
import org.quattor.pan.exceptions.EvaluationException;

public class GlobalVariable {
    private boolean finalFlag = false;
    private Element value = null;
    private Element protectedValue = null;

    public GlobalVariable(boolean finalFlag, Element value) {
        assert (value != null);
        this.finalFlag = finalFlag;
        this.value = value;
        this.protectedValue = value.protect();
    }

    public void setValue(Element newValue) {
        assert (newValue != null);
        if (!this.finalFlag) {
            if (this.value != null) {
                this.value.checkValidReplacement(newValue);
            }
        } else {
            throw EvaluationException.create("MSG_CANNOT_MODIFY_FINAL_GLOBAL_VARIABLE", new Object[0]);
        }
        this.value = newValue;
        this.protectedValue = newValue.protect();
    }

    public Element getValue() {
        return this.protectedValue;
    }

    public Element getUnprotectedValue() {
        return this.value;
    }

    public void setFinalFlag(boolean finalFlag) {
        this.finalFlag = finalFlag;
    }

    public boolean getFinalFlag() {
        return this.finalFlag;
    }

    public String toString() {
        return this.value.toString() + (this.finalFlag ? " (final)" : "");
    }
}

