/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.utils;

import org.quattor.pan.exceptions.EvaluationException;

public class Range {
    private final long min;
    private final long max;

    public Range(String minimum, String maximum) {
        long maxValue;
        long minValue;
        try {
            minValue = minimum != null ? Long.decode(minimum) : 0L;
        }
        catch (NumberFormatException e) {
            throw EvaluationException.create("MSG_MIN_RANGE_VALUE_IS_NOT_VALID_LONG", minimum);
        }
        try {
            maxValue = maximum != null ? Long.decode(maximum) : Long.MAX_VALUE;
        }
        catch (NumberFormatException e) {
            throw EvaluationException.create("MSG_MAX_RANGE_VALUE_IS_NOT_VALID_LONG", maximum);
        }
        this.checkRangeValues(minValue, maxValue);
        this.min = minValue;
        this.max = maxValue;
    }

    public Range(long minimum, long maximum) {
        this.checkRangeValues(minimum, maximum);
        this.min = minimum;
        this.max = maximum;
    }

    public boolean isInRange(long test) {
        return test >= this.min && test <= this.max;
    }

    public boolean isInRange(double test) {
        return test >= (double)this.min && test <= (double)this.max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(Long.toString(this.min));
        sb.append("..");
        if (this.max != Long.MAX_VALUE) {
            sb.append(this.max);
        }
        return sb.toString();
    }

    private void checkRangeValues(long minimum, long maximum) {
        if (minimum < 0L) {
            throw EvaluationException.create("MSG_MIN_RANGE_VALUE_CANNOT_BE_NEGATIVE", minimum);
        }
        if (minimum > maximum) {
            throw EvaluationException.create("MSG_MIN_MUST_BE_LESS_OR_EQUAL_TO_MAX", minimum, maximum);
        }
    }
}

