/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.logging.Level;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.LocalVariableMap;
import org.quattor.pan.template.SelfHolder;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.Template;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.TermFactory;

public final class Create
extends BuiltInFunction {
    private Create(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("create", sourceRange, operations);
        if ((operations.length & 1) != 1) {
            throw SyntaxException.create(sourceRange, "MSG_INVALID_NO_ARGS_CREATE", new Object[0]);
        }
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        return new Create(sourceRange, operations);
    }

    public Element execute(Context context) {
        this.throwExceptionIfCompileTimeContext(context);
        Element[] args = this.calculateArgs(context);
        assert ((args.length & 1) == 1);
        HashResource previousRelativeRoot = context.createRelativeRoot();
        LocalVariableMap oldLocalVariables = context.createLocalVariableMap(null);
        try {
            this.executeWithNamedStructureTemplate(context, ((StringProperty)args[0]).getValue());
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_FIRST_ARG_CREATE", new Object[0]), this.getSourceRange(), context);
        }
        context.restoreLocalVariableMap(oldLocalVariables);
        HashResource root = context.restoreRelativeRoot(previousRelativeRoot);
        for (int i = 1; i < args.length; i += 2) {
            StringProperty key = null;
            try {
                key = (StringProperty)args[i];
                Element value = args[i + 1];
                root.put(TermFactory.create(key), value);
                continue;
            }
            catch (ClassCastException cce) {
                throw new EvaluationException(MessageUtils.format("MSG_INVALID_KEY_CREATE_STRINGS", i, args[i].getTypeAsString()), this.sourceRange);
            }
            catch (InvalidTermException ite) {
                throw new EvaluationException(MessageUtils.format("MSG_INVALID_KEY_CREATE", key));
            }
        }
        return root;
    }

    protected void executeWithNamedStructureTemplate(Context context, String name) throws EvaluationException {
        assert (context != null);
        assert (name != null);
        Template template = null;
        boolean runStatic = false;
        try {
            template = context.localLoad(name);
            if (template == null) {
                template = context.globalLoad(name);
                runStatic = true;
            }
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.getSourceRange(), context);
        }
        if (template == null) {
            throw new EvaluationException("failed to load template: " + name, this.getSourceRange());
        }
        Template.TemplateType includedType = template.type;
        if (includedType != Template.TemplateType.STRUCTURE) {
            throw new EvaluationException("first argument of create() must be the name of structure template", this.getSourceRange());
        }
        context.pushTemplate(template, this.getSourceRange(), Level.INFO, "STRUCTURE");
        SelfHolder self = context.saveSelf();
        template.execute(runStatic, context);
        context.restoreSelf(self);
        context.popTemplate(Level.INFO, "STRUCTURE");
    }
}

