/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public final class BitNot
extends AbstractOperation {
    private BitNot(SourceRange sourceRange, Operation ... operations) {
        super(sourceRange, operations);
        assert (operations.length == 1);
    }

    public static Operation newOperation(SourceRange sourceRange, Operation ... ops) throws SyntaxException {
        assert (ops.length == 1);
        Operation result = null;
        if (ops[0] instanceof Element) {
            try {
                LongProperty a = (LongProperty)ops[0];
                result = BitNot.execute(a);
            }
            catch (ClassCastException cce) {
                throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_BITNOT", new Object[0]), sourceRange);
            }
            catch (EvaluationException ee) {
                throw SyntaxException.create(sourceRange, ee);
            }
        } else {
            result = new BitNot(sourceRange, ops);
        }
        return result;
    }

    public Element execute(Context context) {
        try {
            Element[] args = this.calculateArgs(context);
            LongProperty a = (LongProperty)args[0];
            return BitNot.execute(a);
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_BITNOT", new Object[0]), this.sourceRange);
        }
    }

    private static Element execute(LongProperty a) {
        long v1 = a.getValue();
        return LongProperty.getInstance(v1 ^ 0xFFFFFFFFFFFFFFFFL);
    }
}

