/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.DoubleProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.NumberProperty;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public final class Mult
extends AbstractOperation {
    private Mult(SourceRange sourceRange, Operation ... operations) {
        super(sourceRange, operations);
        assert (operations.length == 2);
    }

    public static Operation newOperation(SourceRange sourceRange, Operation ... ops) throws SyntaxException {
        assert (ops.length == 2);
        Operation result = null;
        if (ops[0] instanceof Element && ops[1] instanceof Element) {
            try {
                NumberProperty a = (NumberProperty)ops[0];
                NumberProperty b = (NumberProperty)ops[1];
                result = Mult.execute(a, b);
            }
            catch (ClassCastException cce) {
                throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_MULT", new Object[0]), sourceRange);
            }
            catch (EvaluationException ee) {
                throw SyntaxException.create(sourceRange, ee);
            }
        } else {
            result = new Mult(sourceRange, ops);
        }
        return result;
    }

    public Element execute(Context context) {
        try {
            Element[] args = this.calculateArgs(context);
            NumberProperty a = (NumberProperty)args[0];
            NumberProperty b = (NumberProperty)args[1];
            return Mult.execute(a, b);
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_MULT", new Object[0]), this.sourceRange);
        }
    }

    private static Element execute(NumberProperty a, NumberProperty b) {
        NumberProperty result = null;
        if (a instanceof LongProperty && b instanceof LongProperty) {
            long l1 = (Long)a.getValue();
            long l2 = (Long)b.getValue();
            result = LongProperty.getInstance(l1 * l2);
        } else {
            double d1 = a.doubleValue();
            double d2 = b.doubleValue();
            result = DoubleProperty.getInstance(d1 * d2);
        }
        return result;
    }
}

