/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.output;

import java.io.PrintWriter;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.output.XMLFormatterUtils;
import org.quattor.pan.utils.Base64;
import org.quattor.pan.utils.XmlUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PanFormatter
implements Formatter {
    private static final PanFormatter instance = new PanFormatter();
    private static final String PAN_NS = "";
    private static final String suffix = "xml";
    private static final String key = "pan";

    private PanFormatter() {
    }

    public static PanFormatter getInstance() {
        return instance;
    }

    public String getFileExtension() {
        return suffix;
    }

    public String getFormatKey() {
        return key;
    }

    public void write(Element root, String rootName, PrintWriter ps) {
        try {
            TransformerHandler handler = XmlUtils.getSaxTransformerHandler();
            handler.setResult(new StreamResult(ps));
            AttributesImpl atts = new AttributesImpl();
            handler.startDocument();
            atts.addAttribute(PAN_NS, null, "format", "CDATA", key);
            atts.addAttribute(PAN_NS, null, "name", "CDATA", rootName);
            this.writeChild(handler, atts, ps, root);
            handler.endDocument();
        }
        catch (SAXException se) {
            CompilerError error = CompilerError.create("MSG_UNEXPECTED_EXCEPTION_WHILE_WRITING_OUTPUT", new Object[0]);
            error.initCause(se);
            throw error;
        }
    }

    private void writeChild(TransformerHandler handler, AttributesImpl atts, PrintWriter ps, Element node) throws SAXException {
        String s;
        String tagName = node.getTypeAsString();
        String stringContents = null;
        if (node instanceof StringProperty) {
            if (!"string".equals(tagName)) {
                atts.addAttribute(PAN_NS, null, "type", "CDATA", tagName);
                tagName = "string";
            }
            if (XMLFormatterUtils.isValidXMLString(s = ((Property)node).toString())) {
                stringContents = s;
            } else {
                stringContents = Base64.encodeBytes(s.getBytes());
                atts.addAttribute(PAN_NS, null, "encoding", "CDATA", "base64");
            }
        }
        handler.startElement(PAN_NS, null, tagName, atts);
        atts.clear();
        if (node instanceof HashResource) {
            HashResource hash = (HashResource)node;
            for (Resource.Entry entry : hash) {
                String name = ((Property)entry.getKey()).toString();
                atts.addAttribute(PAN_NS, null, "name", "CDATA", name);
                this.writeChild(handler, atts, ps, (Element)entry.getValue());
            }
        } else if (node instanceof ListResource) {
            ListResource list = (ListResource)node;
            for (Resource.Entry entry : list) {
                this.writeChild(handler, atts, ps, (Element)entry.getValue());
            }
        } else if (node instanceof StringProperty) {
            handler.characters(stringContents.toCharArray(), 0, stringContents.length());
        } else if (node instanceof Property) {
            s = ((Property)node).toString();
            handler.characters(s.toCharArray(), 0, s.length());
        }
        handler.endElement(PAN_NS, null, tagName);
    }
}

