/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.output;

public class XMLFormatterUtils {
    public static boolean isXMLNameStart(int codepoint) {
        if (codepoint >= Character.codePointAt("A", 0) && codepoint <= Character.codePointAt("Z", 0)) {
            return true;
        }
        if (codepoint == Character.codePointAt("_", 0)) {
            return true;
        }
        if (codepoint >= Character.codePointAt("a", 0) && codepoint <= Character.codePointAt("z", 0)) {
            return true;
        }
        if (codepoint >= 192 && codepoint <= 214) {
            return true;
        }
        if (codepoint >= 216 && codepoint <= 246) {
            return true;
        }
        if (codepoint >= 248 && codepoint <= 767) {
            return true;
        }
        if (codepoint >= 880 && codepoint <= 893) {
            return true;
        }
        if (codepoint >= 895 && codepoint <= 8191) {
            return true;
        }
        if (codepoint >= 8204 && codepoint <= 8205) {
            return true;
        }
        if (codepoint >= 8304 && codepoint <= 8591) {
            return true;
        }
        if (codepoint >= 11264 && codepoint <= 12271) {
            return true;
        }
        if (codepoint >= 12289 && codepoint <= 55295) {
            return true;
        }
        if (codepoint >= 63744 && codepoint <= 64975) {
            return true;
        }
        if (codepoint >= 65008 && codepoint <= 65533) {
            return true;
        }
        return codepoint >= 65536 && codepoint <= 983039;
    }

    public static boolean isXMLNamePart(int codepoint) {
        if (XMLFormatterUtils.isXMLNameStart(codepoint)) {
            return true;
        }
        if (codepoint >= Character.codePointAt("0", 0) && codepoint <= Character.codePointAt("9", 0)) {
            return true;
        }
        if (codepoint == Character.codePointAt("-", 0)) {
            return true;
        }
        if (codepoint == Character.codePointAt(".", 0)) {
            return true;
        }
        if (codepoint == 183) {
            return true;
        }
        if (codepoint >= 768 && codepoint <= 879) {
            return true;
        }
        return codepoint >= 8255 && codepoint <= 8256;
    }

    public static boolean isValidXMLCharacter(int codepoint) {
        if (codepoint >= 32 && codepoint <= 55295) {
            return true;
        }
        if (codepoint == 9 || codepoint == 10 || codepoint == 13) {
            return true;
        }
        if (codepoint >= 57344 && codepoint <= 65533) {
            return true;
        }
        return codepoint >= 65536 && codepoint <= 0x10FFFF;
    }

    public static boolean isValidXMLName(String s) {
        int codePoint;
        if (s == null || "".equals(s)) {
            return false;
        }
        if (!XMLFormatterUtils.isXMLNameStart(s.codePointAt(0))) {
            return false;
        }
        int length = s.length();
        for (int index = 1; index < length; index += Character.charCount(codePoint)) {
            codePoint = s.codePointAt(index);
            if (XMLFormatterUtils.isXMLNamePart(codePoint)) continue;
            return false;
        }
        return !s.toLowerCase().startsWith("xml");
    }

    public static boolean isValidXMLString(String s) {
        int codePoint;
        int length = s.length();
        for (int index = 0; index < length; index += Character.charCount(codePoint)) {
            codePoint = s.codePointAt(index);
            if (XMLFormatterUtils.isValidXMLCharacter(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static String encodeAsXMLName(String s) {
        StringBuilder sb = new StringBuilder("_");
        for (byte b : s.getBytes()) {
            sb.append(Integer.toHexString(b >>> 4 & 0xF));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString();
    }
}

