/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.parser;

import java.io.File;
import org.quattor.pan.parser.Token;
import org.quattor.pan.template.SourceRange;

public class ParseException
extends RuntimeException {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    public File file = null;
    public SourceRange sourceRange = null;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            StringBuilder msg = new StringBuilder();
            msg.append("parse error [");
            msg.append(this.file != null ? this.file.toString() : "<unknown>");
            msg.append(":");
            msg.append(this.sourceRange != null ? this.sourceRange.toString() : "<unknown>");
            msg.append("]\n");
            msg.append(super.getMessage());
            return msg.toString();
        }
        StringBuilder expected = new StringBuilder();
        int maxSize = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                expected.append(this.tokenImage[this.expectedTokenSequences[i][j]]).append(" ");
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected.append("...");
            }
            expected.append(this.eol).append("    ");
        }
        String retval = "parse error ";
        retval = retval + (this.file != null ? "[" + this.file + ":" : "[<unknown>:");
        retval = this.sourceRange != null ? retval + this.sourceRange.toString() + "]\n" : retval + this.currentToken.next.beginLine + "." + this.currentToken.next.beginColumn + "-" + this.currentToken.next.endLine + "." + this.currentToken.next.endLine + "]\n";
        retval = retval + "\nEncountered: ";
        Token tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval = retval + " ";
            }
            if (tok.kind == 0) {
                retval = retval + this.tokenImage[0];
                break;
            }
            retval = retval + this.add_escapes(tok.image);
            tok = tok.next;
        }
        retval = this.expectedTokenSequences.length == 1 ? retval + "\nWas expecting:" + this.eol + "    " : retval + "\nWas expecting one of:" + this.eol + "    ";
        retval = retval + expected.toString();
        return retval;
    }

    protected String add_escapes(String str) {
        StringBuilder retval = new StringBuilder();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

