/* Generated By:JJTree&JavaCC: Do not edit this line. PanParser.java */
package org.quattor.pan.parser;

import org.quattor.pan.dml.data.*;

public class PanParser/*@bgen(jjtree)*/implements PanParserTreeConstants, PanParserConstants {/*@bgen(jjtree)*/
  protected JJTPanParserState jjtree = new JJTPanParserState();
  java.io.File tplFile = null;
  int deprecationLevel = 0;
  boolean debugSuppressed = true;
  org.quattor.pan.CompilerOptions compilerOptions = null;

  /**
   * Set the file name. */
  public void setFile(java.io.File file) {
    if ((file!=null) && (!file.isAbsolute())) {
      file = file.getAbsoluteFile();
    }
    tplFile = file;
  }

  /**
   * Get the file name */
  public java.io.File getFile() {
    return tplFile;
  }

  /**
   * Get the debugging pattern. */
  public boolean setDebugSuppressedFlag(String templateName) {
    boolean enabled = false;
    if (compilerOptions != null) {
      enabled = compilerOptions.checkDebugEnabled(templateName);
    }
    return !enabled;
  }

  /**
   * Set the compiler options.  Will be used to determine debugging status. */
  public void setCompilerOptions(org.quattor.pan.CompilerOptions options) {
    compilerOptions = options;
  }

   /**
    * Write deprecation message to standard output.
    */
   public void deprecated(String message, Token token, int level) {
     if ((compilerOptions != null) && (level <= compilerOptions.deprecationLevel)) {
       StringBuilder msg = new StringBuilder("DEPRECATED ");
       if (token != null) {
         msg.append("[" + tplFile + ":" + token.beginLine + "." + token.beginColumn + "]");
       } else {
         msg.append("[" + tplFile + ":<unknown>]");
       }
       msg.append("\u005cn");
       msg.append(message);

       if (compilerOptions.failOnWarn) {
         ParseException pe = new ParseException(msg.toString());
         pe.sourceRange = PanParserUtils.sourceRangeFromTokens(token, token);
         throw pe;
       } else {
         System.err.println(msg.toString());
       }
     }
   };

/*************************************************************************
End-of-file processing.  
*************************************************************************/
  final public void endOfFile() throws ParseException {
    token = jj_consume_token(0);
    if (token.image != null) {if (true) throw new ParseException(token.image);}
  }

/*************************************************************************
Literals.  
*************************************************************************/
  final public void stringLiteral() throws ParseException {
 /*@bgen(jjtree) Operation */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SINGLE_QUOTED_STRING:
      case DOUBLE_QUOTED_STRING:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SINGLE_QUOTED_STRING:
          t = jj_consume_token(SINGLE_QUOTED_STRING);
          break;
        case DOUBLE_QUOTED_STRING:
          t = jj_consume_token(DOUBLE_QUOTED_STRING);
          break;
        default:
          jj_la1[0] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperation(StringProperty.getInstance(t.image));
    jjtn000.setOperationType(ASTOperation.OperationType.LITERAL);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
        break;
      case HEREDOC_STRING:
        t = jj_consume_token(HEREDOC_STRING);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperation(LongProperty.getInstance(token_source.getHeredocIndex()));
    jjtn000.setOperationType(ASTOperation.OperationType.HEREDOC);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public String longLiteral() throws ParseException {
 /*@bgen(jjtree) Operation */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DECIMAL_LITERAL:
        t = jj_consume_token(DECIMAL_LITERAL);
        break;
      case HEX_LITERAL:
        t = jj_consume_token(HEX_LITERAL);
        break;
      case OCTAL_LITERAL:
        t = jj_consume_token(OCTAL_LITERAL);
        break;
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperation(LongProperty.getInstance(t.image));
    jjtn000.setOperationType(ASTOperation.OperationType.LITERAL);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
    {if (true) return t.image;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  final public void doubleLiteral() throws ParseException {
 /*@bgen(jjtree) Operation */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(DOUBLE_LITERAL);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperation(DoubleProperty.getInstance(t.image));
    jjtn000.setOperationType(ASTOperation.OperationType.LITERAL);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void booleanLiteral() throws ParseException {
 /*@bgen(jjtree) Operation */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        t = jj_consume_token(TRUE);
        break;
      case FALSE:
        t = jj_consume_token(FALSE);
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperation(BooleanProperty.getInstance(t.image));
    jjtn000.setOperationType(ASTOperation.OperationType.LITERAL);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void nullLiteral() throws ParseException {
 /*@bgen(jjtree) Operation */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(NULL_LITERAL);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperation(Null.VALUE);
    jjtn000.setOperationType(ASTOperation.OperationType.LITERAL);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void undefLiteral() throws ParseException {
 /*@bgen(jjtree) Operation */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(UNDEF_LITERAL);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperation(Undef.VALUE);
    jjtn000.setOperationType(ASTOperation.OperationType.LITERAL);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

/*************************************************************************
Path.  A string literal excepting the heredoc format.  Used to simplify
the generated AST.
*************************************************************************/
  final public Token path() throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SINGLE_QUOTED_STRING:
      t = jj_consume_token(SINGLE_QUOTED_STRING);
      break;
    case DOUBLE_QUOTED_STRING:
      t = jj_consume_token(DOUBLE_QUOTED_STRING);
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
   {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

/*************************************************************************
Template syntax.  Just a template declaration followed by a series of
statements.
*************************************************************************/
  final public ASTTemplate template() throws ParseException {
 /*@bgen(jjtree) Template */
  ASTTemplate jjtn000 = new ASTTemplate(JJTTEMPLATE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token f=null, k, n, b, e;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNIQUE:
      case OBJECT:
      case STRUCTURE:
      case DECLARATION:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRUCTURE:
          f = jj_consume_token(STRUCTURE);
          break;
        case OBJECT:
          f = jj_consume_token(OBJECT);
          break;
        case DECLARATION:
          f = jj_consume_token(DECLARATION);
          break;
        case UNIQUE:
          f = jj_consume_token(UNIQUE);
          break;
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[6] = jj_gen;
        ;
      }
      k = jj_consume_token(TEMPLATE);
      n = templateName();
      e = jj_consume_token(SEMICOLON);
      statementSequence();
      endOfFile();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    b = (f!=null) ? f : k;
    PanParserUtils.addSpecialTokens(jjtn000, b);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(b,e));
    jjtn000.setIdentifier(n.image);
    jjtn000.setTemplateType((f!=null) ? f.kind : -1);
    PanParserUtils.replaceHeredocStrings(jjtn000,token_source.getHeredocStrings());
    {if (true) return(jjtn000);}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

/*******************************************************************************
  This is separated in order to set a flag to indicate if debugging calls should
  be included in this template. 
********************************************************************************/
  final public Token templateName() throws ParseException {
  Token n;
    n = jj_consume_token(NS_IDENTIFIER);
    debugSuppressed = setDebugSuppressedFlag(n.image);
    {if (true) return(n);}
    throw new Error("Missing return statement in function");
  }

/*************************************************************************
Statements--assignments, declarations, and includes.
*************************************************************************/
  final public void statement() throws ParseException {
 /*@bgen(jjtree) Statement */
  ASTStatement jjtn000 = new ASTStatement(JJTSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token b=null, e=null, t=null, i=null, f=null, s=null, k=null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        b = jj_consume_token(SEMICOLON);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(b,b));
    jjtn000.setStatementType(ASTStatement.StatementType.NOOP);
        break;
      case INCLUDE:
        /* Static and DML include statements. */
          b = jj_consume_token(INCLUDE);
        dmlSequence();
        e = jj_consume_token(SEMICOLON);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(b,e));
    jjtn000.setStatementType(ASTStatement.StatementType.INCLUDE);
        break;
      case PREFIX:
        /* Set the prefix for resolving relative paths. */
          b = jj_consume_token(PREFIX);
        s = path();
        e = jj_consume_token(SEMICOLON);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(b,e));
    jjtn000.setStatementType(ASTStatement.StatementType.PREFIX);
    jjtn000.setIdentifier(s.image);
        break;
      case VALID:
        /* Validation statement implemented as a bind statement with Element type. */
          b = jj_consume_token(VALID);
        s = path();
        jj_consume_token(ASSIGN);
        dml();
        e = jj_consume_token(SEMICOLON);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(b,e));
    jjtn000.setStatementType(ASTStatement.StatementType.BIND);
    jjtn000.setIdentifier(s.image);
        break;
      case BIND:
        /* Bind statements bind a full type specification to a path. */
          b = jj_consume_token(BIND);
        s = path();
        jj_consume_token(ASSIGN);
        fullTypeSpec();
        e = jj_consume_token(SEMICOLON);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(b,e));
    jjtn000.setStatementType(ASTStatement.StatementType.BIND);
    jjtn000.setIdentifier(s.image);
        break;
      default:
        jj_la1[11] = jj_gen;
        if (jj_2_1(2)) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case FINAL:
            f = jj_consume_token(FINAL);
            break;
          default:
            jj_la1[7] = jj_gen;
            ;
          }
          s = path();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ASSIGN:
            t = jj_consume_token(ASSIGN);
            break;
          case ASSIGN_DEFAULT:
            t = jj_consume_token(ASSIGN_DEFAULT);
            break;
          default:
            jj_la1[8] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          dml();
          e = jj_consume_token(SEMICOLON);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    b=(f!=null)?f:s;
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(b,e));
    jjtn000.setStatementType(ASTStatement.StatementType.ASSIGN);
    jjtn000.setIdentifier(s.image);
    jjtn000.setFinalFlag(f!=null);
    jjtn000.setConditionalFlag(t.kind == PanParserConstants.ASSIGN_DEFAULT);
        } else if (jj_2_2(2)) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case FINAL:
            f = jj_consume_token(FINAL);
            break;
          default:
            jj_la1[9] = jj_gen;
            ;
          }
          k = jj_consume_token(VARIABLE);
          i = jj_consume_token(IDENTIFIER);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ASSIGN:
            t = jj_consume_token(ASSIGN);
            break;
          case ASSIGN_DEFAULT:
            t = jj_consume_token(ASSIGN_DEFAULT);
            break;
          default:
            jj_la1[10] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          dml();
          e = jj_consume_token(SEMICOLON);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    b = (f!=null) ? f : k;
    PanParserUtils.addSpecialTokens(jjtn000, b);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(b,e));
    jjtn000.setStatementType(ASTStatement.StatementType.VARIABLE);
    jjtn000.setIdentifier(i.image);
    jjtn000.setFinalFlag(f!=null);
    jjtn000.setConditionalFlag(t.kind == PanParserConstants.ASSIGN_DEFAULT);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TYPE:
            /* Declare a new type. */
              b = jj_consume_token(TYPE);
            i = jj_consume_token(IDENTIFIER);
            jj_consume_token(ASSIGN);
            fullTypeSpec();
            e = jj_consume_token(SEMICOLON);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    PanParserUtils.addSpecialTokens(jjtn000, b);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(b,e));
    jjtn000.setStatementType(ASTStatement.StatementType.TYPE);
    jjtn000.setIdentifier(i.image);
            break;
          case FUNCTION:
            /* Declare a new function. */
              b = jj_consume_token(FUNCTION);
            i = jj_consume_token(IDENTIFIER);
            jj_consume_token(ASSIGN);
            dml();
            e = jj_consume_token(SEMICOLON);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    PanParserUtils.addSpecialTokens(jjtn000, b);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(b,e));
    jjtn000.setStatementType(ASTStatement.StatementType.FUNCTION);
    jjtn000.setIdentifier(i.image);
            break;
          default:
            jj_la1[12] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

/* A sequence of statements consists of zero or more valid statements. */
  final public void statementSequence() throws ParseException {
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
      case SINGLE_QUOTED_STRING:
      case DOUBLE_QUOTED_STRING:
      case TYPE:
      case BIND:
      case VALID:
      case FINAL:
      case PREFIX:
      case INCLUDE:
      case FUNCTION:
      case VARIABLE:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_1;
      }
      statement();
    }
  }

/*************************************************************************
Type declarations.
*************************************************************************/

/* Type specification possibly with attached validation code and 
   description. */
  final public ASTFullTypeSpec fullTypeSpec() throws ParseException {
 /*@bgen(jjtree) FullTypeSpec */
  ASTFullTypeSpec jjtn000 = new ASTFullTypeSpec(JJTFULLTYPESPEC);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);org.quattor.pan.template.SourceRange t, d = null, w = null;
    try {
      t = typeSpec();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGN:
        d = defaultValue();
        break;
      default:
        jj_la1[14] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
        w = with();
        break;
      default:
        jj_la1[15] = jj_gen;
        ;
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setSourceRange(org.quattor.pan.template.SourceRange.combineSourceRanges(t,d,w));
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  final public org.quattor.pan.template.SourceRange defaultValue() throws ParseException {
 /*@bgen(jjtree) Operation */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t=null;
    try {
      t = jj_consume_token(ASSIGN);
      dml();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperationType(ASTOperation.OperationType.DEFAULT);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
    {if (true) return jjtn000.getSourceRange();}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  final public org.quattor.pan.template.SourceRange with() throws ParseException {
 /*@bgen(jjtree) Operation */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t=null;
    try {
      t = jj_consume_token(WITH);
      dml();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperationType(ASTOperation.OperationType.WITH);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
    {if (true) return jjtn000.getSourceRange();}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

/* Type definition. */
  final public org.quattor.pan.template.SourceRange typeSpec() throws ParseException {
 /*@bgen(jjtree) TypeSpec */
  ASTTypeSpec jjtn000 = new ASTTypeSpec(JJTTYPESPEC);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);org.quattor.pan.template.SourceRange b = null; org.quattor.pan.template.SourceRange e = null;
    try {
      b = baseTypeSpec();
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case LBRACKET:
        case ASTERISK:
          ;
          break;
        default:
          jj_la1[16] = jj_gen;
          break label_2;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
          e = listClause();
          break;
        case LBRACE:
          e = hashClause();
          break;
        case ASTERISK:
          e = linkClause();
          break;
        default:
          jj_la1[17] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setSourceRange(org.quattor.pan.template.SourceRange.combineSourceRanges(b,e));
    {if (true) return jjtn000.getSourceRange();}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

/* Note that this is more permissive than the old pan compiler which
   didn't allow an empty set of parenthesis for the limits clause.  
   An empty set of parentheses are the same as no limits.  
   
   A limits clause is also permissible after a record statement.  This
   was not permitted in previous versions of the pan grammar. */
  final public org.quattor.pan.template.SourceRange baseTypeSpec() throws ParseException {
 /*@bgen(jjtree) BaseTypeSpec */
  ASTBaseTypeSpec jjtn000 = new ASTBaseTypeSpec(JJTBASETYPESPEC);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t = null, b=null, e=null; org.quattor.pan.utils.Range r = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        t = jj_consume_token(IDENTIFIER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          jj_consume_token(LPAREN);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case RANGE:
          case DECIMAL_LITERAL:
          case HEX_LITERAL:
          case OCTAL_LITERAL:
            r = range();
            break;
          default:
            jj_la1[18] = jj_gen;
            ;
          }
          e = jj_consume_token(RPAREN);
          break;
        default:
          jj_la1[19] = jj_gen;
          ;
        }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setIdentifier(t.image); jjtn000.setRange(r);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,(e!=null)?e:t));
    {if (true) return jjtn000.getSourceRange();}
        break;
      case LBRACE:
      case EXTENSIBLE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EXTENSIBLE:
          b = jj_consume_token(EXTENSIBLE);
          break;
        default:
          jj_la1[20] = jj_gen;
          ;
        }
        t = jj_consume_token(LBRACE);
        label_3:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SINGLE_QUOTED_STRING:
          case DOUBLE_QUOTED_STRING:
          case INCLUDE:
            ;
            break;
          default:
            jj_la1[21] = jj_gen;
            break label_3;
          }
          fieldSpec();
        }
        e = jj_consume_token(RBRACE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          jj_consume_token(LPAREN);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case RANGE:
          case DECIMAL_LITERAL:
          case HEX_LITERAL:
          case OCTAL_LITERAL:
            r = range();
            break;
          default:
            jj_la1[22] = jj_gen;
            ;
          }
          e = jj_consume_token(RPAREN);
          break;
        default:
          jj_la1[23] = jj_gen;
          ;
        }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setExtensible(b!=null);
    jjtn000.setRange(r);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens((b!=null)?b:t,e));
    {if (true) return jjtn000.getSourceRange();}
        break;
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  final public void fieldSpec() throws ParseException {
 /*@bgen(jjtree) FieldSpec */
  ASTFieldSpec jjtn000 = new ASTFieldSpec(JJTFIELDSPEC);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token p=null, t=null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SINGLE_QUOTED_STRING:
      case DOUBLE_QUOTED_STRING:
        p = path();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OPTIONAL:
          jj_consume_token(OPTIONAL);
          break;
        case REQUIRED:
          t = jj_consume_token(REQUIRED);
          break;
        default:
          jj_la1[25] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        fullTypeSpec();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    PanParserUtils.addSpecialTokens(jjtn000, p);
    jjtn000.setPath(p.image);
    jjtn000.setRequired(t!=null);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(p,p));
        break;
      case INCLUDE:
        jj_consume_token(INCLUDE);
        t = jj_consume_token(NS_IDENTIFIER);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setInclude(t.image);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
        break;
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public org.quattor.pan.template.SourceRange linkClause() throws ParseException {
 /*@bgen(jjtree) TypeClause */
  ASTTypeClause jjtn000 = new ASTTypeClause(JJTTYPECLAUSE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(ASTERISK);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setClauseType(ASTTypeClause.ClauseType.LINK); jjtn000.setRange(null);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
    {if (true) return jjtn000.getSourceRange();}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  final public org.quattor.pan.template.SourceRange listClause() throws ParseException {
 /*@bgen(jjtree) TypeClause */
  ASTTypeClause jjtn000 = new ASTTypeClause(JJTTYPECLAUSE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token b,e; org.quattor.pan.utils.Range r = null;
    try {
      b = jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RANGE:
      case DECIMAL_LITERAL:
      case HEX_LITERAL:
      case OCTAL_LITERAL:
        r = range();
        break;
      default:
        jj_la1[27] = jj_gen;
        ;
      }
      e = jj_consume_token(RBRACKET);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setClauseType(ASTTypeClause.ClauseType.LIST); jjtn000.setRange(r);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(b,e));
    {if (true) return jjtn000.getSourceRange();}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  final public org.quattor.pan.template.SourceRange hashClause() throws ParseException {
 /*@bgen(jjtree) TypeClause */
  ASTTypeClause jjtn000 = new ASTTypeClause(JJTTYPECLAUSE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token b,e; org.quattor.pan.utils.Range r = null;
    try {
      b = jj_consume_token(LBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RANGE:
      case DECIMAL_LITERAL:
      case HEX_LITERAL:
      case OCTAL_LITERAL:
        r = range();
        break;
      default:
        jj_la1[28] = jj_gen;
        ;
      }
      e = jj_consume_token(RBRACE);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setClauseType(ASTTypeClause.ClauseType.HASH); jjtn000.setRange(r);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(b,e));
    {if (true) return jjtn000.getSourceRange();}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

/* Note: This is a more inclusive syntax than previous versions of the
   pan grammar.  This will allow any legal long literal syntax to be 
   used to specify the bounds.  Previous versions only allowed decimal
   long values. */
  final public org.quattor.pan.utils.Range range() throws ParseException {
  String min=null, max=null; Token t=null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECIMAL_LITERAL:
    case HEX_LITERAL:
    case OCTAL_LITERAL:
      min = longLiteral();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RANGE:
        t = jj_consume_token(RANGE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DECIMAL_LITERAL:
        case HEX_LITERAL:
        case OCTAL_LITERAL:
          max = longLiteral();
          break;
        default:
          jj_la1[29] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[30] = jj_gen;
        ;
      }
    jjtree.popNode();
    if (max!=null) jjtree.popNode();
    if (max==null && t==null) max=min;
    {if (true) return new org.quattor.pan.utils.Range(min,max);}
      break;
    case RANGE:
      jj_consume_token(RANGE);
      max = longLiteral();
    jjtree.popNode();
    {if (true) return new org.quattor.pan.utils.Range(null,max);}
      break;
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*************************************************************************
Expressions.
*************************************************************************/
  final public void dmlSequence() throws ParseException {
 /*@bgen(jjtree) #Operation(> 1) */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t=null, e=null;
    try {
      t = jj_consume_token(LBRACE);
      dml();
      label_4:
      while (true) {
        if (jj_2_3(2)) {
          ;
        } else {
          break label_4;
        }
        jj_consume_token(SEMICOLON);
        dml();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[32] = jj_gen;
        ;
      }
      e = jj_consume_token(RBRACE);
    jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
      jjtn000.setOperationType(ASTOperation.OperationType.DML);
      jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,e));
    }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
    }
    }
  }

  final public void dmlVariable() throws ParseException {
 /*@bgen(jjtree) Variable */
  ASTVariable jjtn000 = new ASTVariable(JJTVARIABLE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t=null, e=null;
    try {
      t = jj_consume_token(IDENTIFIER);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
          ;
          break;
        default:
          jj_la1[33] = jj_gen;
          break label_5;
        }
        jj_consume_token(LBRACKET);
        dml();
        e = jj_consume_token(RBRACKET);
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperationType(ASTOperation.OperationType.VARIABLE);
    jjtn000.setName(t.image);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,(e!=null)?e:t));
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public ASTOperation dml() throws ParseException {
 /*@bgen(jjtree) Operation */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
      case LPAREN:
      case PLUS:
      case MINUS:
      case NOT:
      case BIT_NOT:
      case UNDEF_LITERAL:
      case NULL_LITERAL:
      case TRUE:
      case FALSE:
      case DECIMAL_LITERAL:
      case HEX_LITERAL:
      case OCTAL_LITERAL:
      case DOUBLE_LITERAL:
      case HEREDOC_STRING:
      case SINGLE_QUOTED_STRING:
      case DOUBLE_QUOTED_STRING:
      case IF:
      case FOR:
      case WHILE:
      case FOREACH:
      case IDENTIFIER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
        case PLUS:
        case MINUS:
        case NOT:
        case BIT_NOT:
        case UNDEF_LITERAL:
        case NULL_LITERAL:
        case TRUE:
        case FALSE:
        case DECIMAL_LITERAL:
        case HEX_LITERAL:
        case OCTAL_LITERAL:
        case DOUBLE_LITERAL:
        case HEREDOC_STRING:
        case SINGLE_QUOTED_STRING:
        case DOUBLE_QUOTED_STRING:
        case IF:
        case FOR:
        case WHILE:
        case FOREACH:
        case IDENTIFIER:
          expression();
          break;
        case LBRACE:
          dmlSequence();
          break;
        default:
          jj_la1[34] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperationType(ASTOperation.OperationType.DML);
    {if (true) return jjtn000;}
        break;
      case SEMICOLON:
        emptyStatement();
        break;
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  final public void ifStatement() throws ParseException {
 /*@bgen(jjtree) Operation */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(IF);
      jj_consume_token(LPAREN);
      dml();
      jj_consume_token(RPAREN);
      dml();
      if (jj_2_4(2)) {
        jj_consume_token(ELSE);
        dml();
      } else {
        ;
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperationType(ASTOperation.OperationType.IF);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void whileStatement() throws ParseException {
 /*@bgen(jjtree) Operation */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(WHILE);
      jj_consume_token(LPAREN);
      dml();
      jj_consume_token(RPAREN);
      dml();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperationType(ASTOperation.OperationType.WHILE);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void foreachStatement() throws ParseException {
 /*@bgen(jjtree) Operation */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(FOREACH);
      jj_consume_token(LPAREN);
      dmlVariable();
      jj_consume_token(SEMICOLON);
      dmlVariable();
      jj_consume_token(SEMICOLON);
      dml();
      jj_consume_token(RPAREN);
      dml();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperationType(ASTOperation.OperationType.FOREACH);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void forStatement() throws ParseException {
 /*@bgen(jjtree) Operation */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(FOR);
      jj_consume_token(LPAREN);
      dml();
      jj_consume_token(SEMICOLON);
      dml();
      jj_consume_token(SEMICOLON);
      dml();
      jj_consume_token(RPAREN);
      dml();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setOperationType(ASTOperation.OperationType.FOR);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

/* Empty DML statements are illegal because there is no way to 
   determine what should be the correct return value from it. */
  final public void emptyStatement() throws ParseException {
  Token t;
    t = jj_consume_token(SEMICOLON);
    ParseException pe = new ParseException("illegal empty DML statement");
    pe.sourceRange = PanParserUtils.sourceRangeFromTokens(t,t);
    {if (true) throw pe;}
  }

  final public void expression() throws ParseException {
    assignmentExpression();
  }

  final public void assignmentExpression() throws ParseException {
 /*@bgen(jjtree) #Operation(> 1) */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t=null;
    try {
      label_6:
      while (true) {
        if (jj_2_5(2147483647)) {
          ;
        } else {
          break label_6;
        }
        dmlVariable();
        t = jj_consume_token(ASSIGN);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IF:
        ifStatement();
        break;
      case WHILE:
        whileStatement();
        break;
      case FOR:
        forStatement();
        break;
      case FOREACH:
        foreachStatement();
        break;
      case LPAREN:
      case PLUS:
      case MINUS:
      case NOT:
      case BIT_NOT:
      case UNDEF_LITERAL:
      case NULL_LITERAL:
      case TRUE:
      case FALSE:
      case DECIMAL_LITERAL:
      case HEX_LITERAL:
      case OCTAL_LITERAL:
      case DOUBLE_LITERAL:
      case HEREDOC_STRING:
      case SINGLE_QUOTED_STRING:
      case DOUBLE_QUOTED_STRING:
      case IDENTIFIER:
        logicalOrExpression();
        break;
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
      jjtn000.setOperationType(ASTOperation.OperationType.ASSIGN);
      jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
    }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
    }
    }
  }

  final public void logicalOrExpression() throws ParseException {
    logicalAndExpression();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[37] = jj_gen;
        break label_7;
      }
      jj_consume_token(OR);
                                  ASTlogicalOrExpression jjtn001 = new ASTlogicalOrExpression(JJTLOGICALOREXPRESSION);
                                  boolean jjtc001 = true;
                                  jjtree.openNodeScope(jjtn001);
      try {
        logicalAndExpression();
      } catch (Throwable jjte001) {
                                  if (jjtc001) {
                                    jjtree.clearNodeScope(jjtn001);
                                    jjtc001 = false;
                                  } else {
                                    jjtree.popNode();
                                  }
                                  if (jjte001 instanceof RuntimeException) {
                                    {if (true) throw (RuntimeException)jjte001;}
                                  }
                                  if (jjte001 instanceof ParseException) {
                                    {if (true) throw (ParseException)jjte001;}
                                  }
                                  {if (true) throw (Error)jjte001;}
      } finally {
                                  if (jjtc001) {
                                    jjtree.closeNodeScope(jjtn001,  2);
                                  }
      }
    }
  }

  final public void logicalAndExpression() throws ParseException {
    inclusiveOrExpression();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[38] = jj_gen;
        break label_8;
      }
      jj_consume_token(AND);
                                    ASTlogicalAndExpression jjtn001 = new ASTlogicalAndExpression(JJTLOGICALANDEXPRESSION);
                                    boolean jjtc001 = true;
                                    jjtree.openNodeScope(jjtn001);
      try {
        inclusiveOrExpression();
      } catch (Throwable jjte001) {
                                    if (jjtc001) {
                                      jjtree.clearNodeScope(jjtn001);
                                      jjtc001 = false;
                                    } else {
                                      jjtree.popNode();
                                    }
                                    if (jjte001 instanceof RuntimeException) {
                                      {if (true) throw (RuntimeException)jjte001;}
                                    }
                                    if (jjte001 instanceof ParseException) {
                                      {if (true) throw (ParseException)jjte001;}
                                    }
                                    {if (true) throw (Error)jjte001;}
      } finally {
                                    if (jjtc001) {
                                      jjtree.closeNodeScope(jjtn001,  2);
                                    }
      }
    }
  }

  final public void inclusiveOrExpression() throws ParseException {
    exclusiveOrExpression();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_IOR:
        ;
        break;
      default:
        jj_la1[39] = jj_gen;
        break label_9;
      }
      jj_consume_token(BIT_IOR);
                                        ASTBitwiseInclusiveOrOperation jjtn001 = new ASTBitwiseInclusiveOrOperation(JJTBITWISEINCLUSIVEOROPERATION);
                                        boolean jjtc001 = true;
                                        jjtree.openNodeScope(jjtn001);
      try {
        exclusiveOrExpression();
      } catch (Throwable jjte001) {
                                        if (jjtc001) {
                                          jjtree.clearNodeScope(jjtn001);
                                          jjtc001 = false;
                                        } else {
                                          jjtree.popNode();
                                        }
                                        if (jjte001 instanceof RuntimeException) {
                                          {if (true) throw (RuntimeException)jjte001;}
                                        }
                                        if (jjte001 instanceof ParseException) {
                                          {if (true) throw (ParseException)jjte001;}
                                        }
                                        {if (true) throw (Error)jjte001;}
      } finally {
                                        if (jjtc001) {
                                          jjtree.closeNodeScope(jjtn001,  2);
                                        }
      }
    }
  }

  final public void exclusiveOrExpression() throws ParseException {
    bitAndExpression();
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_XOR:
        ;
        break;
      default:
        jj_la1[40] = jj_gen;
        break label_10;
      }
      jj_consume_token(BIT_XOR);
                                   ASTBitwiseExclusiveOrOperation jjtn001 = new ASTBitwiseExclusiveOrOperation(JJTBITWISEEXCLUSIVEOROPERATION);
                                   boolean jjtc001 = true;
                                   jjtree.openNodeScope(jjtn001);
      try {
        bitAndExpression();
      } catch (Throwable jjte001) {
                                   if (jjtc001) {
                                     jjtree.clearNodeScope(jjtn001);
                                     jjtc001 = false;
                                   } else {
                                     jjtree.popNode();
                                   }
                                   if (jjte001 instanceof RuntimeException) {
                                     {if (true) throw (RuntimeException)jjte001;}
                                   }
                                   if (jjte001 instanceof ParseException) {
                                     {if (true) throw (ParseException)jjte001;}
                                   }
                                   {if (true) throw (Error)jjte001;}
      } finally {
                                   if (jjtc001) {
                                     jjtree.closeNodeScope(jjtn001,  2);
                                   }
      }
    }
  }

  final public void bitAndExpression() throws ParseException {
    equalityExpression();
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_AND:
        ;
        break;
      default:
        jj_la1[41] = jj_gen;
        break label_11;
      }
      jj_consume_token(BIT_AND);
                                     ASTBitwiseAndOperation jjtn001 = new ASTBitwiseAndOperation(JJTBITWISEANDOPERATION);
                                     boolean jjtc001 = true;
                                     jjtree.openNodeScope(jjtn001);
      try {
        equalityExpression();
      } catch (Throwable jjte001) {
                                     if (jjtc001) {
                                       jjtree.clearNodeScope(jjtn001);
                                       jjtc001 = false;
                                     } else {
                                       jjtree.popNode();
                                     }
                                     if (jjte001 instanceof RuntimeException) {
                                       {if (true) throw (RuntimeException)jjte001;}
                                     }
                                     if (jjte001 instanceof ParseException) {
                                       {if (true) throw (ParseException)jjte001;}
                                     }
                                     {if (true) throw (Error)jjte001;}
      } finally {
                                     if (jjtc001) {
                                       jjtree.closeNodeScope(jjtn001,  2);
                                     }
      }
    }
  }

  final public void equalityExpression() throws ParseException {
    relationalExpression();
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
      case NE:
        ;
        break;
      default:
        jj_la1[42] = jj_gen;
        break label_12;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
      ASTEQOperation jjtn001 = new ASTEQOperation(JJTEQOPERATION);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
        try {
          jj_consume_token(EQ);
          relationalExpression();
        } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
        } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001,  2);
      }
        }
        break;
      case NE:
      ASTNEOperation jjtn002 = new ASTNEOperation(JJTNEOPERATION);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002);
        try {
          jj_consume_token(NE);
          relationalExpression();
        } catch (Throwable jjte002) {
      if (jjtc002) {
        jjtree.clearNodeScope(jjtn002);
        jjtc002 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte002 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte002;}
      }
      if (jjte002 instanceof ParseException) {
        {if (true) throw (ParseException)jjte002;}
      }
      {if (true) throw (Error)jjte002;}
        } finally {
      if (jjtc002) {
        jjtree.closeNodeScope(jjtn002,  2);
      }
        }
        break;
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void relationalExpression() throws ParseException {
    additiveExpression();
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GT:
      case LT:
      case GE:
      case LE:
        ;
        break;
      default:
        jj_la1[44] = jj_gen;
        break label_13;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
      ASTLTOperation jjtn001 = new ASTLTOperation(JJTLTOPERATION);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
        try {
          jj_consume_token(LT);
          additiveExpression();
        } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
        } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001,  2);
      }
        }
        break;
      case GT:
      ASTGTOperation jjtn002 = new ASTGTOperation(JJTGTOPERATION);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002);
        try {
          jj_consume_token(GT);
          additiveExpression();
        } catch (Throwable jjte002) {
      if (jjtc002) {
        jjtree.clearNodeScope(jjtn002);
        jjtc002 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte002 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte002;}
      }
      if (jjte002 instanceof ParseException) {
        {if (true) throw (ParseException)jjte002;}
      }
      {if (true) throw (Error)jjte002;}
        } finally {
      if (jjtc002) {
        jjtree.closeNodeScope(jjtn002,  2);
      }
        }
        break;
      case LE:
      ASTLEOperation jjtn003 = new ASTLEOperation(JJTLEOPERATION);
      boolean jjtc003 = true;
      jjtree.openNodeScope(jjtn003);
        try {
          jj_consume_token(LE);
          additiveExpression();
        } catch (Throwable jjte003) {
      if (jjtc003) {
        jjtree.clearNodeScope(jjtn003);
        jjtc003 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte003 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte003;}
      }
      if (jjte003 instanceof ParseException) {
        {if (true) throw (ParseException)jjte003;}
      }
      {if (true) throw (Error)jjte003;}
        } finally {
      if (jjtc003) {
        jjtree.closeNodeScope(jjtn003,  2);
      }
        }
        break;
      case GE:
      ASTGEOperation jjtn004 = new ASTGEOperation(JJTGEOPERATION);
      boolean jjtc004 = true;
      jjtree.openNodeScope(jjtn004);
        try {
          jj_consume_token(GE);
          additiveExpression();
        } catch (Throwable jjte004) {
      if (jjtc004) {
        jjtree.clearNodeScope(jjtn004);
        jjtc004 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte004 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte004;}
      }
      if (jjte004 instanceof ParseException) {
        {if (true) throw (ParseException)jjte004;}
      }
      {if (true) throw (Error)jjte004;}
        } finally {
      if (jjtc004) {
        jjtree.closeNodeScope(jjtn004,  2);
      }
        }
        break;
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void additiveExpression() throws ParseException {
    multiplicativeExpression();
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[46] = jj_gen;
        break label_14;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      ASTAddOperation jjtn001 = new ASTAddOperation(JJTADDOPERATION);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
        try {
          jj_consume_token(PLUS);
          multiplicativeExpression();
        } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
        } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001,  2);
      }
        }
        break;
      case MINUS:
      ASTSubOperation jjtn002 = new ASTSubOperation(JJTSUBOPERATION);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002);
        try {
          jj_consume_token(MINUS);
          multiplicativeExpression();
        } catch (Throwable jjte002) {
      if (jjtc002) {
        jjtree.clearNodeScope(jjtn002);
        jjtc002 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte002 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte002;}
      }
      if (jjte002 instanceof ParseException) {
        {if (true) throw (ParseException)jjte002;}
      }
      {if (true) throw (Error)jjte002;}
        } finally {
      if (jjtc002) {
        jjtree.closeNodeScope(jjtn002,  2);
      }
        }
        break;
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void multiplicativeExpression() throws ParseException {
    unaryExpression();
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MOD:
      case DIV:
      case ASTERISK:
        ;
        break;
      default:
        jj_la1[48] = jj_gen;
        break label_15;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
      ASTMulOperation jjtn001 = new ASTMulOperation(JJTMULOPERATION);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
        try {
          jj_consume_token(ASTERISK);
          unaryExpression();
        } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
        } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001,  2);
      }
        }
        break;
      case DIV:
      ASTDivOperation jjtn002 = new ASTDivOperation(JJTDIVOPERATION);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002);
        try {
          jj_consume_token(DIV);
          unaryExpression();
        } catch (Throwable jjte002) {
      if (jjtc002) {
        jjtree.clearNodeScope(jjtn002);
        jjtc002 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte002 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte002;}
      }
      if (jjte002 instanceof ParseException) {
        {if (true) throw (ParseException)jjte002;}
      }
      {if (true) throw (Error)jjte002;}
        } finally {
      if (jjtc002) {
        jjtree.closeNodeScope(jjtn002,  2);
      }
        }
        break;
      case MOD:
      ASTModOperation jjtn003 = new ASTModOperation(JJTMODOPERATION);
      boolean jjtc003 = true;
      jjtree.openNodeScope(jjtn003);
        try {
          jj_consume_token(MOD);
          unaryExpression();
        } catch (Throwable jjte003) {
      if (jjtc003) {
        jjtree.clearNodeScope(jjtn003);
        jjtc003 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte003 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte003;}
      }
      if (jjte003 instanceof ParseException) {
        {if (true) throw (ParseException)jjte003;}
      }
      {if (true) throw (Error)jjte003;}
        } finally {
      if (jjtc003) {
        jjtree.closeNodeScope(jjtn003,  2);
      }
        }
        break;
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void unaryExpression() throws ParseException {
 /*@bgen(jjtree) #Operation( t != null) */
  ASTOperation jjtn000 = new ASTOperation(JJTOPERATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t=null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        t = jj_consume_token(PLUS);
        functionalExpression();
    jjtree.closeNodeScope(jjtn000,  t != null);
    jjtc000 = false;
    jjtn000.setOperationType(ASTOperation.OperationType.PLUS);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
        break;
      case MINUS:
        t = jj_consume_token(MINUS);
        functionalExpression();
    jjtree.closeNodeScope(jjtn000,  t != null);
    jjtc000 = false;
    jjtn000.setOperationType(ASTOperation.OperationType.MINUS);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
        break;
      case NOT:
        t = jj_consume_token(NOT);
        functionalExpression();
    jjtree.closeNodeScope(jjtn000,  t != null);
    jjtc000 = false;
    jjtn000.setOperationType(ASTOperation.OperationType.NOT);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
        break;
      case BIT_NOT:
        t = jj_consume_token(BIT_NOT);
        functionalExpression();
    jjtree.closeNodeScope(jjtn000,  t != null);
    jjtc000 = false;
    jjtn000.setOperationType(ASTOperation.OperationType.BIT_NOT);
    jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,t));
        break;
      case LPAREN:
      case UNDEF_LITERAL:
      case NULL_LITERAL:
      case TRUE:
      case FALSE:
      case DECIMAL_LITERAL:
      case HEX_LITERAL:
      case OCTAL_LITERAL:
      case DOUBLE_LITERAL:
      case HEREDOC_STRING:
      case SINGLE_QUOTED_STRING:
      case DOUBLE_QUOTED_STRING:
      case IDENTIFIER:
        functionalExpression();
        break;
      default:
        jj_la1[50] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000,  t != null);
    }
    }
  }

  final public void functionalExpression() throws ParseException {
 /*@bgen(jjtree) #Function( t != null) */
  ASTFunction jjtn000 = new ASTFunction(JJTFUNCTION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t=null, e=null;
    try {
      if (jj_2_7(2)) {
        t = jj_consume_token(IDENTIFIER);
        jj_consume_token(LPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case SEMICOLON:
        case LPAREN:
        case PLUS:
        case MINUS:
        case NOT:
        case BIT_NOT:
        case UNDEF_LITERAL:
        case NULL_LITERAL:
        case TRUE:
        case FALSE:
        case DECIMAL_LITERAL:
        case HEX_LITERAL:
        case OCTAL_LITERAL:
        case DOUBLE_LITERAL:
        case HEREDOC_STRING:
        case SINGLE_QUOTED_STRING:
        case DOUBLE_QUOTED_STRING:
        case IF:
        case FOR:
        case WHILE:
        case FOREACH:
        case IDENTIFIER:
          dml();
          break;
        default:
          jj_la1[51] = jj_gen;
          ;
        }
        label_16:
        while (true) {
          if (jj_2_6(2)) {
            ;
          } else {
            break label_16;
          }
          jj_consume_token(COMMA);
          dml();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          break;
        default:
          jj_la1[52] = jj_gen;
          ;
        }
        e = jj_consume_token(RPAREN);
    jjtree.closeNodeScope(jjtn000,  t != null);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
      jjtn000.setOperationType(ASTOperation.OperationType.FUNCTION);
      jjtn000.setName(t.image);
      if (debugSuppressed) {
          // Mark functions with special name to indicate the call should be optimized out.
        if ("debug".equals(t.image)) {
          jjtn000.setName("-suppress-debug-");
        }
        if ("traceback".equals(t.image)) {
          jjtn000.setName("-suppress-traceback-");
        }
      }
      jjtn000.setSourceRange(PanParserUtils.sourceRangeFromTokens(t,e));
    }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
        case UNDEF_LITERAL:
        case NULL_LITERAL:
        case TRUE:
        case FALSE:
        case DECIMAL_LITERAL:
        case HEX_LITERAL:
        case OCTAL_LITERAL:
        case DOUBLE_LITERAL:
        case HEREDOC_STRING:
        case SINGLE_QUOTED_STRING:
        case DOUBLE_QUOTED_STRING:
        case IDENTIFIER:
          primaryExpression();
          break;
        default:
          jj_la1[53] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000,  t != null);
    }
    }
  }

  final public void primaryExpression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECIMAL_LITERAL:
    case HEX_LITERAL:
    case OCTAL_LITERAL:
      longLiteral();
      break;
    case DOUBLE_LITERAL:
      doubleLiteral();
      break;
    case HEREDOC_STRING:
    case SINGLE_QUOTED_STRING:
    case DOUBLE_QUOTED_STRING:
      stringLiteral();
      break;
    case UNDEF_LITERAL:
      undefLiteral();
      break;
    case NULL_LITERAL:
      nullLiteral();
      break;
    case TRUE:
    case FALSE:
      booleanLiteral();
      break;
    case IDENTIFIER:
      dmlVariable();
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      dml();
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_3R_51() {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(GT)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_3R_50()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_55()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_scan_token(BIT_XOR)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_scan_token(BIT_IOR)) return true;
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_scan_token(NE)) return true;
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) return true;
    }
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_41()) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_3R_48()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_53()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_3R_46()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_51()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_3R_44()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_49()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_3R_42()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_47()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_3R_41()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_45()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_19()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_3R_40()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_43()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_29() {
    if (jj_3R_19()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_17() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) return true;
    }
    return false;
  }

  private boolean jj_3R_28() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_29()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_scan_token(UNDEF_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_scan_token(NULL_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_18()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_18()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_18()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_18()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) return true;
    }
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_3R_89()) return true;
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_38() {
    if (jj_scan_token(FOREACH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_19()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_19()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_18()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_scan_token(DOUBLE_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_76() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_18()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_85() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_18()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_18()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_3R_25()) return true;
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_18()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_scan_token(HEREDOC_STRING)) return true;
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_91()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_6()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(11)) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_68() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) return true;
    }
    return false;
  }

  private boolean jj_3R_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) return true;
    }
    return false;
  }

  private boolean jj_3R_20() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_23()) {
    jj_scanpos = xsp;
    if (jj_3R_24()) return true;
    }
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_92() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) return true;
    }
    return false;
  }

  private boolean jj_3R_87() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) return true;
    }
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_scan_token(BIT_NOT)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_19() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_22()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_scan_token(NOT)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_18()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_3()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(10)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) jj_scanpos = xsp;
    if (jj_scan_token(VARIABLE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_54() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_scan_token(MOD)) return true;
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3_1() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) jj_scanpos = xsp;
    if (jj_3R_17()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) return true;
    }
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_scan_token(DIV)) return true;
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_31() {
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3R_69() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(ASTERISK)) return true;
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_3R_54()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_69()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    }
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_3R_52()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_63()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_scan_token(GE)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_scan_token(LE)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public PanParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[55];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x20000,0x400,0x0,0x400,0x20000,0x0,0x4080,0x4080,0x2000000,0x1000,0x0,0x0,0x2000000,0x1000,0x80,0x300,0x0,0x2000000,0x2000000,0x0,0x2000000,0x2000000,0x400,0x4000,0x804c1080,0x804c1480,0x804c1000,0x4000000,0x8000000,0x10000000,0x20000000,0x40000000,0x0,0x0,0x1800000,0x1800000,0xc0000,0xc0000,0x300000,0x300000,0x804c1000,0x804c1480,0x800,0x1000,0x1000,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x30000,0x38000,0x1c00,0x300,0x30000,0x60000000,0x60000000,0x8000000,0x10,0x8000000,0x10,0x15000000,0x800000,0x1d830000,0x0,0x200000,0x40000,0x40000,0x1c00,0x0,0x0,0x30000,0x1c00,0x0,0x0,0x0,0x30000,0x1c00,0x1c00,0x1c00,0x0,0x1c00,0x0,0x0,0x821bbfc0,0x821bbfc0,0x821bbfc0,0x0,0x0,0x0,0x0,0x0,0x3,0x3,0xc,0xc,0x0,0x0,0x40000,0x40000,0x3bfc0,0x821bbfc0,0x0,0x3bfc0,0x3bfc0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x50,0x50,0x0,0x0,0x0,0x0,0x1,0x4,0xd,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x1,0x0,0x0,0xa0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x0,0x80,0x80,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[7];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public PanParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public PanParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new PanParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public PanParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new PanParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public PanParser(PanParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(PanParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[74];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 55; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 74; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 7; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
