/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.ant;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.quattor.ant.DebugPatterns;
import org.quattor.ant.DependencyChecker;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.CompilerOptions;
import org.quattor.pan.CompilerResults;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.output.FormatterUtils;
import org.quattor.pan.repository.SourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanCompilerTask
extends Task {
    private LinkedList<File> objectFiles = new LinkedList();
    private File includeroot = null;
    private List<DirSet> includes = new LinkedList<DirSet>();
    private LinkedList<File> includeDirectories = new LinkedList();
    private boolean debugTask = false;
    private boolean debugVerbose = false;
    private List<Pattern> debugIncludePatterns = new LinkedList<Pattern>();
    private List<Pattern> debugExcludePatterns = new LinkedList<Pattern>();
    private Pattern ignoreDependencyPattern = null;
    private boolean xmlWriteEnabled = true;
    private boolean depWriteEnabled = true;
    private int iterationLimit = 5000;
    private int callDepthLimit = 50;
    private Formatter formatter;
    private File outputDirectory = null;
    private File sessionDirectory = null;
    private boolean checkDependencies = true;
    private int nthread = 0;
    private boolean verbose = false;
    private boolean gzipOutput = false;
    private int deprecationLevel = 0;
    private boolean failOnWarn = false;
    private boolean forceBuild = false;
    protected static final String debugIndent = "    ";
    private String loggingFlags = "none";
    private File logfile = null;
    private File annotationDirectory = null;
    private File annotationBaseDirectory = null;
    private int batchSize = 0;
    private String rootElement = null;

    public PanCompilerTask() {
        this.setFormatter("xmldb");
    }

    public void execute() throws BuildException {
        if (this.includes.size() > 0) {
            if (this.includeroot == null) {
                throw new BuildException("includeroot must be specified to use 'includes' parameter");
            }
            Path antpath = new Path(this.getProject());
            for (DirSet dirset : this.includes) {
                dirset.setDir(this.includeroot);
                antpath.addDirset(dirset);
            }
            this.addPaths(antpath);
        }
        CompilerOptions options = null;
        try {
            options = new CompilerOptions(this.debugIncludePatterns, this.debugExcludePatterns, this.xmlWriteEnabled, this.depWriteEnabled, this.iterationLimit, this.callDepthLimit, this.formatter, this.outputDirectory, this.sessionDirectory, this.includeDirectories, this.nthread, this.gzipOutput, this.deprecationLevel, this.forceBuild, this.annotationDirectory, this.annotationBaseDirectory, this.failOnWarn, this.rootElement);
        }
        catch (SyntaxException e) {
            throw new BuildException("invalid root element: " + e.getMessage());
        }
        if (this.debugTask) {
            System.err.println(options);
        }
        if (this.debugVerbose) {
            System.err.println("includeroot: " + this.includeroot);
            System.err.println("Profiles to process : \n");
            for (File objectFile : this.objectFiles) {
                System.err.println(debugIndent + objectFile + "\n");
            }
        }
        List<File> outdatedFiles = this.objectFiles;
        if (this.outputDirectory != null && this.checkDependencies) {
            DependencyChecker checker = new DependencyChecker(this.includeDirectories, this.ignoreDependencyPattern);
            outdatedFiles = checker.extractOutdatedFiles(this.objectFiles, this.outputDirectory, this.gzipOutput);
            if (this.debugVerbose) {
                System.err.println("Outdated profiles: \n");
                for (File objectFile : outdatedFiles) {
                    System.err.println(debugIndent + objectFile + "\n");
                }
            }
        }
        if (this.verbose) {
            System.out.println(outdatedFiles.size() + "/" + this.objectFiles.size() + " object template(s) being processed");
        }
        CompilerLogging.activateLoggers(this.loggingFlags);
        CompilerLogging.setLogFile(this.logfile);
        List<List<File>> batches = this.batchOutdatedFiles(outdatedFiles);
        boolean hadError = false;
        for (List<File> batch : batches) {
            CompilerResults results = Compiler.run(options, null, batch);
            boolean batchHadError = results.print(this.verbose);
            if (!batchHadError) continue;
            hadError = true;
        }
        if (hadError) {
            throw new BuildException("Compilation failed; see messages.");
        }
    }

    public void setIncludeRoot(File includeroot) {
        this.includeroot = includeroot;
        if (!includeroot.exists()) {
            throw new BuildException("includeroot doesn't exist: " + includeroot);
        }
        if (!includeroot.isDirectory()) {
            throw new BuildException("includeroot must be a directory: " + includeroot);
        }
    }

    public void setIncludes(String includes) {
        String[] globs;
        for (String glob : globs = includes.split("[\\s,]+")) {
            DirSet dirset = new DirSet();
            dirset.setIncludes(glob);
            this.includes.add(dirset);
        }
    }

    public void addConfiguredPath(Path path) {
        if (path != null) {
            this.addPaths(path);
        }
    }

    private void addPaths(Path p) {
        for (String d : p.list()) {
            File dir = new File(d);
            if (!dir.exists() || !dir.isDirectory() || this.includeDirectories.contains(dir)) continue;
            this.includeDirectories.add(dir);
        }
    }

    public void addConfiguredFileSet(FileSet fileset) {
        this.addFiles(fileset);
    }

    private void addFiles(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        File basedir = ds.getBasedir();
        for (String f : ds.getIncludedFiles()) {
            if (!SourceType.hasSourceFileExtension(f)) continue;
            this.objectFiles.add(new File(basedir, f));
        }
    }

    public void setCallDepthLimit(int callDepthLimit) {
        this.callDepthLimit = callDepthLimit;
    }

    public void setDebugTask(int debugTask) {
        this.debugTask = debugTask != 0;
        this.debugVerbose = debugTask > 1;
    }

    public void addConfiguredDebug(DebugPatterns debugPatterns) {
        this.debugIncludePatterns.add(debugPatterns.getInclude());
        this.debugExcludePatterns.add(debugPatterns.getExclude());
    }

    public void setDepWriteEnabled(boolean depWriteEnabled) {
        this.depWriteEnabled = depWriteEnabled;
    }

    public void setIterationLimit(int iterationLimit) {
        this.iterationLimit = iterationLimit;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setSessionDirectory(File sessionDirectory) {
        this.sessionDirectory = sessionDirectory;
    }

    public void setXmlWriteEnabled(boolean xmlWriteEnabled) {
        this.xmlWriteEnabled = xmlWriteEnabled;
    }

    public void setCheckDependencies(boolean checkDependencies) {
        this.checkDependencies = checkDependencies;
    }

    public void setFormatter(String name) {
        this.formatter = FormatterUtils.getFormatterInstance(name);
        if (this.formatter == null) {
            throw new BuildException("unknown output formatter: " + name);
        }
    }

    public void setAnnotationDirectory(File annotationDirectory) {
        this.annotationDirectory = annotationDirectory;
    }

    public void setAnnotationBaseDirectory(File annotationBaseDirectory) {
        this.annotationBaseDirectory = annotationBaseDirectory;
    }

    public int getNthread() {
        return this.nthread;
    }

    public void setNthread(int nthread) {
        this.nthread = nthread;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setGzipOutput(boolean gzipOutput) {
        this.gzipOutput = gzipOutput;
    }

    public void setIgnoreDependencyPattern(String ignoreDependencyPattern) {
        try {
            Pattern pattern;
            this.ignoreDependencyPattern = pattern = Pattern.compile(ignoreDependencyPattern);
        }
        catch (PatternSyntaxException e) {
            throw new BuildException("invalid ignore dependency pattern: " + e.getMessage());
        }
    }

    public void setDeprecationLevel(int deprecationLevel) {
        this.deprecationLevel = deprecationLevel;
    }

    public void setFailOnWarn(boolean failOnWarn) {
        this.failOnWarn = failOnWarn;
    }

    public void setForceBuild(boolean forceBuild) {
        this.forceBuild = forceBuild;
    }

    public void setLogging(String loggingFlags) {
        this.loggingFlags = loggingFlags;
    }

    public void setLogfile(File logfile) {
        this.logfile = logfile;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize > 0 ? batchSize : 0;
    }

    public void setRootElement(String rootElement) {
        this.rootElement = rootElement;
    }

    private List<List<File>> batchOutdatedFiles(List<File> outdatedFiles) {
        LinkedList<List<File>> batches = new LinkedList<List<File>>();
        int total = outdatedFiles.size();
        int myBatchSize = this.batchSize <= 0 ? outdatedFiles.size() : this.batchSize;
        for (int start = 0; start < total; start += myBatchSize) {
            int end = Math.min(start + myBatchSize, total);
            batches.add(outdatedFiles.subList(start, end));
        }
        return batches;
    }
}

