/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.cache;

import java.io.File;
import java.net.URI;
import java.util.concurrent.Future;
import org.quattor.pan.Compiler;
import org.quattor.pan.cache.AbstractCache;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.parser.ASTTemplate;
import org.quattor.pan.tasks.CompileResult;
import org.quattor.pan.tasks.CompileTask;
import org.quattor.pan.tasks.Task;
import org.quattor.pan.tasks.TaskResult;
import org.quattor.pan.tasks.WriteAnnotationTask;
import org.quattor.pan.tasks.WriteDepTask;
import org.quattor.pan.tasks.WriteXmlTask;
import org.quattor.pan.template.Template;
import org.quattor.pan.utils.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileCache
extends AbstractCache<CompileResult> {
    private final PostCompileProcessor postCompileProcessor;

    public CompileCache(Compiler compiler) {
        this(compiler, 1000);
    }

    public CompileCache(Compiler compiler, int size) {
        super(compiler, size);
        this.postCompileProcessor = new PostCompileProcessor(compiler, compiler.options.xmlWriteEnabled, compiler.options.depWriteEnabled);
    }

    public Future<CompileResult> compile(String tplfile) {
        CompileTask task = this.createTask(tplfile);
        this.compiler.submit(task);
        return task;
    }

    protected CompileTask createTask(String tplfile) {
        return new CompileTask(tplfile, this.postCompileProcessor, this.compiler.options);
    }

    @Override
    protected TaskResult.ResultType getExecutorQueueType() {
        return TaskResult.ResultType.COMPILED;
    }

    public static final String getRelativePath(File baseDirectory, File file) {
        URI fileURI;
        URI baseURI;
        URI relativeURI;
        String relativePath = null;
        if (baseDirectory != null && file != null && !(relativeURI = (baseURI = baseDirectory.toURI()).relativize(fileURI = file.toURI())).isAbsolute()) {
            relativePath = relativeURI.toString();
        }
        return relativePath;
    }

    public static File annotationOutputFile(File annotationDirectory, String relativePath) {
        if (relativePath != null) {
            String relativeOutputPath = relativePath + ".annotation.xml";
            relativeOutputPath = FileUtils.localizeFilename(relativeOutputPath);
            return new File(annotationDirectory, relativeOutputPath);
        }
        return null;
    }

    public static class PostCompileProcessor {
        private final Compiler compiler;
        private final boolean doXML;
        private final boolean doDep;

        public PostCompileProcessor(Compiler compiler, boolean doXML, boolean doDep) {
            this.compiler = compiler;
            this.doXML = doXML;
            this.doDep = doDep;
        }

        public void process(ASTTemplate ast, Template template) {
            boolean doAnno;
            Task task;
            if (template.type == Template.TemplateType.OBJECT) {
                String objectName = template.name;
                if (this.doXML) {
                    Formatter formatter = this.compiler.options.formatter;
                    File outputDirectory = this.compiler.options.outputDirectory;
                    task = new WriteXmlTask(formatter, this.compiler.options.gzipOutput, this.compiler, objectName, outputDirectory);
                    this.compiler.submit(task);
                }
                if (this.doDep) {
                    File outputDirectory = this.compiler.options.outputDirectory;
                    task = new WriteDepTask(this.compiler, objectName, outputDirectory);
                    this.compiler.submit(task);
                }
            }
            boolean bl = doAnno = this.compiler.options.annotationDirectory != null && this.compiler.options.annotationBaseDirectory != null && template.sourceFile != null;
            if (doAnno) {
                String relativePath = CompileCache.getRelativePath(this.compiler.options.annotationBaseDirectory, template.sourceFile.getPath());
                File outputFile = CompileCache.annotationOutputFile(this.compiler.options.annotationDirectory, relativePath);
                task = new WriteAnnotationTask(outputFile, ast);
                this.compiler.submit(task);
            }
        }
    }
}

