/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.data;

import java.util.Map;
import java.util.Set;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.utils.Range;
import org.quattor.pan.utils.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectedHashResource
extends HashResource {
    private final HashResource baseHash;

    public ProtectedHashResource(HashResource baseHash) {
        this.baseHash = baseHash;
    }

    @Override
    public Element duplicate() {
        return this.baseHash.duplicate();
    }

    @Override
    public Element get(Term key) throws InvalidTermException {
        return this.baseHash.get(key);
    }

    @Override
    public Element put(Term key, Element newValue) throws InvalidTermException {
        throw CompilerError.create("MSG_ILLEGAL_WRITE_TO_PROTECTED_HASH", new Object[0]);
    }

    @Override
    public int size() {
        return this.baseHash.size();
    }

    @Override
    public Set<Term> keySet() {
        return this.baseHash.keySet();
    }

    @Override
    public String locateUndefinedElement() {
        return this.baseHash.locateUndefinedElement();
    }

    @Override
    public void checkRange(Range range) throws ValidationException {
        this.baseHash.checkRange(range);
    }

    @Override
    public Element protect() {
        return this;
    }

    @Override
    public int hashCode() {
        return this.baseHash.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    protected Map<String, Element> getBackingMap() {
        return this.baseHash.getBackingMap();
    }

    @Override
    public String toString() {
        return this.baseHash.toString();
    }

    @Override
    public Resource.Iterator iterator() {
        return this.baseHash.iterator();
    }

    @Override
    public boolean isProtected() {
        return true;
    }

    @Override
    public void rput(Term[] terms, int index, Element value) throws InvalidTermException {
        throw CompilerError.create("MSG_ILLEGAL_WRITE_TO_PROTECTED_HASH", new Object[0]);
    }

    @Override
    public Element writableCopy() {
        return new HashResource(this.baseHash);
    }
}

