/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.exceptions.SystemException;
import org.quattor.pan.repository.SourceFile;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.FileUtils;
import org.quattor.pan.utils.StringUtils;

public final class FileContents
extends BuiltInFunction {
    private FileContents(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("file_contents", sourceRange, operations);
        String relativePath;
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_ARG_REQ", "file_contents");
        }
        if (operations[0] instanceof Element && (relativePath = FileContents.verifyRelativePath((Element)operations[0])) == null) {
            throw SyntaxException.create(sourceRange, "MSG_RELATIVE_FILE_REQ", "file_contents");
        }
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        return new FileContents(sourceRange, operations);
    }

    public Element execute(Context context) {
        this.throwExceptionIfCompileTimeContext(context);
        Element[] args = this.calculateArgs(context);
        assert (args.length == 1);
        String relativeFileName = FileContents.verifyRelativePath(args[0]);
        if (relativeFileName == null) {
            throw EvaluationException.create(this.sourceRange, "MSG_RELATIVE_FILE_REQ", this.name);
        }
        SourceFile srcFile = context.lookupFile(relativeFileName);
        if (!srcFile.isAbsent()) {
            if (srcFile.getPath().isDirectory()) {
                throw EvaluationException.create(this.sourceRange, "MSG_DIR_NOT_ALLOWED", this.name);
            }
            try {
                return FileContents.readFileAsStringProperty(srcFile);
            }
            catch (IOException e) {
                throw new SystemException(e.getLocalizedMessage(), srcFile.getPath());
            }
        }
        throw EvaluationException.create(this.sourceRange, "MSG_NONEXISTANT_FILE", relativeFileName);
    }

    private static StringProperty readFileAsStringProperty(SourceFile source) throws IOException {
        Reader reader = source.getReader();
        String contents = StringUtils.readCompletely(reader);
        return StringProperty.getInstance(contents);
    }

    private static String verifyRelativePath(Element element) {
        try {
            String s = ((StringProperty)element).getValue();
            s = FileUtils.localizeFilename(s);
            File f = new File(s);
            if (f.isAbsolute()) {
                return null;
            }
            return f.toString();
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

