/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Replace
extends BuiltInFunction {
    private Replace(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("replace", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 3) {
            throw SyntaxException.create(sourceRange, "MSG_3_ARGS_REQ", "replace");
        }
        return new Replace(sourceRange, operations);
    }

    public Element execute(Context context) {
        assert (this.ops.length == 3);
        Pattern regex = null;
        try {
            String re = ((StringProperty)this.ops[0].execute(context)).getValue();
            regex = Pattern.compile(re);
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("first argument to replace() must be a regular expression string", this.getSourceRange(), context);
        }
        catch (PatternSyntaxException pse) {
            throw new EvaluationException("invalid regular expression: " + pse.getLocalizedMessage(), this.getSourceRange(), context);
        }
        String repl = null;
        try {
            repl = ((StringProperty)this.ops[1].execute(context)).getValue();
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("second argument to replace() must be a replacement string", this.getSourceRange(), context);
        }
        String target = null;
        try {
            target = ((StringProperty)this.ops[2].execute(context)).getValue();
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("third argument to replace() must be a string", this.getSourceRange(), context);
        }
        String result = regex.matcher(target).replaceAll(repl);
        return StringProperty.getInstance(result);
    }
}

