/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Term;
import org.quattor.pan.utils.TermFactory;

public final class Split
extends BuiltInFunction {
    private Split(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("split", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length < 2 || operations.length > 3) {
            throw SyntaxException.create(sourceRange, "MSG_2_OR_3_ARGS", "split");
        }
        return new Split(sourceRange, operations);
    }

    public Element execute(Context context) {
        assert (this.ops.length == 2 || this.ops.length == 3);
        Pattern regex = null;
        try {
            String re = ((StringProperty)this.ops[0].execute(context)).getValue();
            regex = Pattern.compile(re);
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("first argument to split() must be a regular expression string", this.getSourceRange(), context);
        }
        catch (PatternSyntaxException pse) {
            throw new EvaluationException("invalid regular expression: " + pse.getLocalizedMessage(), this.getSourceRange(), context);
        }
        int limit = 0;
        if (this.ops.length == 3) {
            try {
                limit = ((LongProperty)this.ops[1].execute(context)).getValue().intValue();
            }
            catch (ClassCastException cce) {
                throw new EvaluationException("second argument to split() must be a long value", this.getSourceRange(), context);
            }
        }
        String target = null;
        try {
            int index = this.ops.length == 2 ? 1 : 2;
            target = ((StringProperty)this.ops[index].execute(context)).getValue();
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("last argument to split() must be a string", this.getSourceRange(), context);
        }
        String[] results = regex.split(target, limit);
        ListResource list = new ListResource();
        long index = 0L;
        for (String s : results) {
            Term t = TermFactory.create(index++);
            try {
                list.put(t, (Element)StringProperty.getInstance(s));
            }
            catch (InvalidTermException ite) {
                throw CompilerError.create("MSG_INVALID_KEY_OR_INDEX", new Object[0]);
            }
        }
        return list;
    }
}

