/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.Locale;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class ToUpperCase
extends BuiltInFunction {
    private ToUpperCase(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("to_uppercase", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_STRING_ARG_REQ", "to_uppercase");
        }
        return new ToUpperCase(sourceRange, operations);
    }

    public Element execute(Context context) {
        assert (this.ops.length == 1);
        Element result = this.ops[0].execute(context);
        try {
            String s = ((StringProperty)result).getValue();
            return StringProperty.getInstance(s.toUpperCase(Locale.US));
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("invalid argument to to_uppercase(); string required", this.sourceRange, context);
        }
    }
}

