/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.DoubleProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.NumberProperty;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public final class Add
extends AbstractOperation {
    private Add(SourceRange sourceRange, Operation ... ops) {
        super(sourceRange, ops);
        assert (ops.length == 2);
    }

    public static Operation newOperation(SourceRange sourceRange, Operation ... ops) throws SyntaxException {
        assert (ops.length == 2);
        Operation result = null;
        if (ops[0] instanceof Element && ops[1] instanceof Element) {
            try {
                Property a = (Property)ops[0];
                Property b = (Property)ops[1];
                result = Add.execute(sourceRange, a, b);
            }
            catch (ClassCastException cce) {
                throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_ADD", new Object[0]), sourceRange);
            }
            catch (EvaluationException ee) {
                throw SyntaxException.create(sourceRange, ee);
            }
        } else {
            result = new Add(sourceRange, ops);
        }
        return result;
    }

    public Element execute(Context context) {
        try {
            Element[] args = this.calculateArgs(context);
            Property a = (Property)args[0];
            Property b = (Property)args[1];
            return Add.execute(this.sourceRange, a, b);
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_ADD", new Object[0]), this.sourceRange);
        }
    }

    private static Element execute(SourceRange sourceRange, Property a, Property b) {
        assert (a != null);
        assert (b != null);
        Property result = null;
        if (a instanceof LongProperty && b instanceof LongProperty) {
            long l1 = (Long)a.getValue();
            long l2 = (Long)b.getValue();
            result = LongProperty.getInstance(l1 + l2);
        } else if (a instanceof NumberProperty && b instanceof NumberProperty) {
            double d1 = ((NumberProperty)a).doubleValue();
            double d2 = ((NumberProperty)b).doubleValue();
            result = DoubleProperty.getInstance(d1 + d2);
        } else if (a instanceof StringProperty && b instanceof StringProperty) {
            String s1 = (String)a.getValue();
            String s2 = (String)b.getValue();
            result = StringProperty.getInstance(s1 + s2);
        } else {
            throw new EvaluationException(MessageUtils.format("MSG_MISMATCHED_ARGS_ADD", new Object[0]), sourceRange);
        }
        return result;
    }
}

